/*
 * Decompiled with CFR 0.152.
 */
package edu.uha.miage;

import caseine.tags.ClassTestPriority;
import caseine.tags.ToCheck;
import caseine.tags.ToCompare;
import caseine.tags.ToDo;
import edu.uha.miage.Point;
import edu.uha.miage.Segment;

@ClassTestPriority(value=5)
public class Triangle {
    @ToCheck(priority=30, grade=1.0)
    @ToDo(value="3.01. Les trois segments du triangle : s1, s2, s3")
    private Segment s1;
    @ToCheck(priority=30, grade=1.0)
    @ToDo(value="3.01. Les trois segments du triangle : s1, s2, s3")
    private Segment s2;
    @ToCheck(priority=30, grade=1.0)
    @ToDo(value="3.01. Les trois segments du triangle : s1, s2, s3")
    private Segment s3;

    @ToCheck(priority=31, grade=5.0)
    @ToDo(value="3.02. \u00c9crire le constructeur avec ses trois sommets")
    public Triangle(Point p1, Point p2, Point p3) {
        this.s1 = new Segment(p1, p2);
        this.s2 = new Segment(p2, p3);
        this.s3 = new Segment(p3, p1);
    }

    @ToCheck(priority=32, grade=2.0)
    @ToDo(value="3.03. getP1() qui retourne le premier sommet de ce triangle")
    public Point getP1() {
        return this.s1.getP1();
    }

    @ToDo(value="3.04. getP2() qui retourne le deuxi\u00e8me sommet de ce triangle")
    @ToCheck(priority=32, grade=2.0)
    public Point getP2() {
        return this.s2.getP1();
    }

    @ToDo(value="3.05. getP3() qui retourne le troisi\u00e8me sommet de ce triangle")
    @ToCheck(priority=32, grade=2.0)
    public Point getP3() {
        return this.s3.getP1();
    }

    @ToCheck(priority=33, grade=2.0)
    @ToDo(value="3.06. setP1() qui met \u00e0 jour le premier sommet de ce triangle")
    public void setP1(Point p1) {
        this.s1 = new Segment(p1, this.s2.getP1());
        this.s3 = new Segment(this.s3.getP1(), p1);
    }

    @ToDo(value="3.07. setP2() qui met \u00e0 jour le deuxi\u00e8me sommet de ce triangle")
    @ToCheck(priority=33, grade=2.0)
    public void setP2(Point p2) {
        this.s1 = new Segment(this.s1.getP1(), p2);
        this.s2 = new Segment(p2, this.s3.getP1());
    }

    @ToDo(value="3.08. setP3() qui met \u00e0 jour le troisi\u00e8me sommet de ce triangle")
    @ToCheck(priority=33, grade=2.0)
    public void setP3(Point p3) {
        this.s2 = new Segment(this.s2.getP1(), p3);
        this.s3 = new Segment(p3, this.s1.getP1());
    }

    @ToDo(value="3.05. Retourner le p\u00e9rim\u00e8tre de ce triangle")
    @ToCheck(value="Signature of Triangle.getPerimetre()", priority=34, grade=1.0)
    @ToCompare(value="Behavior of Triangle.getPerimetre()", priority=35, grade=5.0)
    public double getPerimetre() {
        return this.s1.getLongueur() + this.s2.getLongueur() + this.s3.getLongueur();
    }

    @ToCheck(value="Signature of Triangle.getSurface()", priority=36, grade=1.0)
    @ToDo(value="3.06. Retourner la surface de ce triangle")
    @ToCompare(value="Behavior of Triangle.getSurface()", priority=37, grade=5.0)
    public double getSurface() {
        double a = this.s1.getLongueur();
        double b = this.s2.getLongueur();
        double c = this.s3.getLongueur();
        double p = (a + b + c) / 2.0;
        return Math.sqrt(p * (p - a) * (p - b) * (p - c));
    }

    @ToDo(value="3.07. Retourner le barycentre de ce triangle")
    @ToCheck(value="Signature of Triangle.getBaryCentre()", priority=38, grade=1.0)
    @ToCompare(value="Behavior of Triangle.getBaryCentre()", priority=39, grade=5.0)
    public Point getBaryCentre() {
        Point a = this.s1.getP1();
        Point b = this.s2.getP1();
        Point c = this.s3.getP1();
        return new Point((a.getX() + b.getX() + c.getX()) / 3.0, (a.getY() + b.getY() + c.getY()) / 3.0);
    }

    @ToCheck(priority=40, grade=1.0)
    @ToDo(value="3.08. La m\u00e9thode toString()")
    public String toString() {
        return "<" + this.s1 + ", " + this.s2 + ", " + this.s3 + ">";
    }
}

