/*
 * Copyright 2019: Christophe Saint-Marcel
 * This software is part of the Caseine project.
 * This software was developped with the support of the following organizations:
 * Université Grenoble Alpes
 * Institut Polytechnique de Grenoble
 * 
 * 
 * This file is part of the VPL Design Tool.
 * The VPL Design Tool is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * The VPL Design Tool is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with the VPL Design Tool.  If not, see <https://www.gnu.org/licenses/>.
 */
package caseine;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import javax.json.JsonObject;

import vplwsclient.RestJsonMoodleClient;
import vplwsclient.RestJsonMoodleClient.VPLService;
import vplwsclient.VplFile;
import vplwsclient.exception.VplException;

/**
 * The Reset command is not operational in this version as it is not yet used.
 * That is just an example of what we have to do to implement a future Reset command.
 * @author christophe
 *
 */
public class Reset {

	private static String url = "http://193.55.48.132/webservice/rest/server.php";
	private static String token = "7b09fcf71d36853c4fa7cba13b700e87";
	private static String vplId = "7313";

	public static void main(String[] args) {
		
		RestJsonMoodleClient client = new RestJsonMoodleClient(vplId, token, url);
		client.setServerSupportsIsBinary(true);
		
		List<VplFile> emptyFiles = new ArrayList<>();
		
		// Requested Files
		try {
			JsonObject result = client.callServiceWithFiles(VPLService.VPL_SAVE_RF.toString(), emptyFiles);
			System.out.println(result);
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (VplException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

		// Execution Files
		try {
			JsonObject result = client.callServiceWithFiles(VPLService.VPL_SAVE_EF.toString(), emptyFiles);
			System.out.println(result);
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (VplException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

		// Corrected Files
		try {
			JsonObject result = client.callServiceWithFiles(VPLService.VPL_SAVE_CF.toString(), emptyFiles);
			System.out.println(result);
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (VplException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

	}

}
