/*
 * Decompiled with CFR 0.152.
 */
package caseine;

import caseine.exceptions.TestDirectoryMissingException;
import caseine.exceptions.UnitTestsFileMissingException;
import caseine.project.BadIDEException;
import caseine.project.CaseineCommonProject;
import caseine.project.CaseineCppProject;
import caseine.project.CaseineJavaProject;
import caseine.project.CaseineProject;
import caseine.project.CaseineProjectAlreadyExistingException;
import caseine.project.CaseineProjectLoader;
import caseine.project.CaseinePythonProject;
import caseine.project.FileMissingException;
import caseine.project.MavenProjectException;
import caseine.project.NotACaseineProjectException;
import caseine.project.NothingPushedException;
import caseine.project.VPLIDMissingException;
import java.io.IOException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import vplwsclient.exception.MoodleWebServiceException;
import vplwsclient.exception.VplConnectionException;
import vplwsclient.exception.VplException;

public class Caseine {
    private static String url = "https://moodle.caseine.org/webservice/rest/server.php";
    private static String token = "";
    private static Options options = new Options();

    public static void main(String[] args) throws Exception {
        DefaultParser parser = new DefaultParser();
        CommandLine cmd = parser.parse(options, args);
        if (cmd.hasOption("h")) {
            Caseine.printUsage();
            System.exit(0);
        }
        if (!cmd.hasOption("t")) {
            System.out.println("The token is mandatory");
            System.exit(0);
        } else {
            token = cmd.getOptionValue("token");
        }
        String projectPath = ".";
        String vplId = "0";
        String[] remainingArgs = cmd.getArgs();
        if (remainingArgs != null && remainingArgs.length >= 1) {
            projectPath = remainingArgs[0];
        }
        if (cmd.hasOption("vplId")) {
            vplId = cmd.getOptionValue("vplId");
        }
        if (!vplId.equals("0")) {
            if (cmd.hasOption("d")) {
                Caseine.documentation(projectPath, vplId, url, token, cmd.hasOption("settings"));
            } else {
                Caseine.clean(projectPath);
                Caseine.local(projectPath, vplId, null);
                Caseine.push(projectPath, vplId, url, token, null, cmd.hasOption("settings"));
            }
        }
    }

    private static void printUsage() {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("java -cp /path/to/vplplugin.jar caseine.Push [OPTIONS] [projectFile]", "With OPTIONS in:", options, "projectFile is the folder containing the original maven project. Defaults to \".\"", false);
    }

    public static void generate(String projectPath, String vplId, String lang, String ide, boolean mvn, int template, boolean settings) throws CaseineProjectAlreadyExistingException, IOException, BadIDEException, TestDirectoryMissingException, FileMissingException, UnitTestsFileMissingException {
        CaseineCommonProject proj = null;
        switch (lang) {
            case "python": {
                proj = new CaseinePythonProject(projectPath, vplId, url, token, settings);
                break;
            }
            case "cpp": {
                proj = new CaseineCppProject(projectPath, vplId, url, token, settings);
                break;
            }
            default: {
                proj = new CaseineJavaProject(projectPath, vplId, ide, url, token, settings);
            }
        }
        proj.generate(mvn, template);
    }

    public static void local(String projectPath, String vplId, ClassLoader cl) throws IOException, ClassNotFoundException, NotACaseineProjectException, MavenProjectException {
        CaseineProject proj = CaseineProjectLoader.getProject(projectPath, vplId, null, null, null, false);
        proj.local(cl);
    }

    public static void push(String projectPath, String vplId, String url, String token, ClassLoader cl, boolean settings) throws IOException, ClassNotFoundException, VplException, VPLIDMissingException, MavenProjectException, NotACaseineProjectException, NothingPushedException {
        CaseineProject proj = CaseineProjectLoader.getProject(projectPath, vplId, null, url, token, settings);
        proj.push(cl);
    }

    public static void clean(String projectPath) throws IOException, NotACaseineProjectException {
        CaseineProject proj = CaseineProjectLoader.getProject(projectPath, null, null, null, null, false);
        proj.clean();
    }

    public static void nature(String projectPath, String vplId) throws CaseineProjectAlreadyExistingException, IOException, NotACaseineProjectException {
        CaseineProject proj = CaseineProjectLoader.getProject(projectPath, vplId, null, null, null, false);
        proj.nature();
    }

    public static void documentation(String projectPath, String vplId, String url, String token, boolean settings) throws VplConnectionException, MoodleWebServiceException, IOException, NotACaseineProjectException {
        CaseineProject proj = CaseineProjectLoader.getProject(projectPath, vplId, null, url, token, settings);
        proj.documentation();
    }

    public static void udpateSettings(String projectPath, String vplId, String url, String token, boolean settings) throws VplConnectionException, MoodleWebServiceException, IOException, NotACaseineProjectException {
        CaseineProject proj = CaseineProjectLoader.getProject(projectPath, vplId, null, url, token, settings);
        proj.updateSettings();
    }

    public static boolean isGenerated(String projectPath) throws NotACaseineProjectException {
        CaseineProject proj = CaseineProjectLoader.getProject(projectPath, null, null, null, null, true);
        return proj.isGenerated();
    }

    static {
        options.addOption("t", "token", true, "Your token.");
        options.addOption("h", "help", false, "Prints usage and exits.");
        options.addOption("d", "doc", false, "Synchronizes the documentation.");
        options.addOption("v", "vplId", true, "specify the vplid. If unspecified, only generate gaseine files.");
    }
}

