/*
 * Decompiled with CFR 0.152.
 */
package caseine;

import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;

public interface CleanFolder {
    public static void clean(Path folder) throws IOException {
        Function<Path, Stream> walk = p -> {
            try {
                return Files.walk(p, new FileVisitOption[0]);
            }
            catch (IOException e) {
                return Stream.empty();
            }
        };
        Consumer<Path> delete = p -> {
            try {
                Files.delete(p);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        };
        Files.list(folder).flatMap(walk).sorted(Comparator.reverseOrder()).forEach(delete);
    }
}

