/*
 * Decompiled with CFR 0.152.
 */
package caseine;

import caseine.CleanFolder;
import caseine.project.CaseineJavaProject;
import caseine.publication.Publisher;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.json.JsonObject;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import vplwsclient.FileUtils;
import vplwsclient.RestJsonMoodleClient;
import vplwsclient.VplFile;
import vplwsclient.exception.VplException;

@Deprecated(since="0.0.60", forRemoval=true)
public class Push {
    private static final String RF = "rf";
    private static final String EF = "ef";
    private static final String CF = "cf";
    private static final String PATH_SRC = File.separator + "src";
    private static final String PATH_CLASSES = File.separator + "classes";
    private static final String PATH_TEST = File.separator + "test";
    private static final String PATH_RESOURCES_SRC = File.separator + "resources" + File.separator + "src";
    private static final String PATH_RESOURCES_TEST = File.separator + "resources" + File.separator + "test";
    private static final String PATH_RESOURCES_LIB = File.separator + "resources" + File.separator + "lib";
    private static final String PLUGIN_LIB = "caseine.vpl.tools.plugin.jar";
    private static String url = "https://moodle.caseine.org/webservice/rest/server.php";
    private static String token = "ca240f18444b233238a47c7fcff30df4";
    private static Options options = new Options();
    private static String PATH_BIN;

    public static void main(String[] args) throws Exception {
        DefaultParser parser = new DefaultParser();
        CommandLine cmd = parser.parse(options, args);
        if (cmd.hasOption("h")) {
            Push.printUsage();
            System.exit(0);
        }
        String projectPath = ".";
        String vplId = "0";
        String[] remainingArgs = cmd.getArgs();
        if (remainingArgs != null && remainingArgs.length >= 1) {
            projectPath = remainingArgs[0];
        }
        if (cmd.hasOption("vplId")) {
            vplId = cmd.getOptionValue("vplId");
        }
        Push.clean(projectPath);
        Push.publish(projectPath, null);
        if (!vplId.equals("0")) {
            Push.publishMoodle(projectPath, vplId, token, url);
        }
    }

    private static void printUsage() {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("java -cp /path/to/vplplugin.jar caseine.Push [OPTIONS] [projectFile]", "With OPTIONS in:", options, "projectFile is the folder containing the original maven project. Defaults to \".\"", false);
    }

    public static void publish(String projectPath, ClassLoader contextClassLoader) throws IOException, ClassNotFoundException {
        Push.clean(projectPath);
        List jarFiles = FileUtils.listFiles((String)(projectPath + PATH_RESOURCES_LIB));
        URL[] urls = new URL[jarFiles.size() + 1];
        for (int i = 0; i < jarFiles.size(); ++i) {
            urls[i] = ((File)jarFiles.get(i)).toURI().toURL();
        }
        urls[jarFiles.size()] = new File(projectPath + Push.getPATH_BIN() + "classes").toURI().toURL();
        Publisher pbsher = new Publisher(new File(projectPath + PATH_SRC).toPath(), new File(projectPath + PATH_CLASSES).toPath(), new File(projectPath + PATH_TEST).toPath(), new File(projectPath + PATH_RESOURCES_SRC).toPath(), new File(projectPath + PATH_RESOURCES_TEST).toPath(), new File(projectPath + Push.getPATH_OUTPUT()).toPath(), contextClassLoader);
        try {
            pbsher.publishAll();
            CaseineJavaProject.fillDocCaseineFile(pbsher, projectPath);
        }
        catch (ClassNotFoundException cnfe) {
            Push.clean(projectPath);
            throw cnfe;
        }
        catch (NullPointerException ex) {
            throw new NullPointerException("IN " + projectPath + "<-->");
        }
        File libDirectory = new File(projectPath + Push.getPATH_EXECUTION_FILES() + "lib");
        libDirectory.mkdir();
        Files.copy(new FileInputStream(new File(projectPath + Push.getPATH_BIN() + "lib/caseine.vpl.tools.plugin.jar")), Paths.get(libDirectory.getAbsolutePath(), PLUGIN_LIB), new CopyOption[0]);
        libDirectory = new File(projectPath + Push.getPATH_REQUESTED_FILES() + "lib");
        libDirectory.mkdir();
        File libResourceDirectory = new File(projectPath + PATH_RESOURCES_LIB);
        if (libResourceDirectory.exists()) {
            for (int i = 0; i < jarFiles.size(); ++i) {
                Files.copy(new FileInputStream((File)jarFiles.get(i)), Paths.get(libDirectory.getAbsolutePath(), ((File)jarFiles.get(i)).getName()), new CopyOption[0]);
            }
        }
        File casesFile = new File(projectPath + Push.getPATH_EXECUTION_FILES() + "vpl_evaluate.cases");
        casesFile.createNewFile();
        Iterator iter = pbsher.iterator();
        BufferedWriter writer = new BufferedWriter(new FileWriter(casesFile));
        writer.write("JunitFiles = ");
        while (iter.hasNext()) {
            String classes = (String)iter.next();
            System.out.println(classes);
            writer.write((String)classes + ", ");
        }
        writer.close();
        for (Object p : pbsher.getPathToRemove()) {
            Path toRemove = new File(projectPath + Push.getPATH_REQUESTED_FILES(), p.toString()).toPath();
            Files.deleteIfExists(toRemove);
        }
        String requestedTestPath = projectPath + Push.getPATH_REQUESTED_FILES() + File.separator + "test";
        for (Path p : pbsher.getPathToTest()) {
            Path toTest = new File(projectPath + Push.getPATH_REQUESTED_FILES(), p.toString()).toPath();
            Path toTest2 = new File(requestedTestPath, p.toString()).toPath();
            if (!toTest2.getParent().toFile().exists()) {
                toTest2.getParent().toFile().mkdirs();
            }
            Files.move(toTest, toTest2, new CopyOption[0]);
        }
        String correctedTestPath = projectPath + Push.getPATH_CORRECTED_FILES() + File.separator + "test";
        for (Path p : pbsher.getPathToTest()) {
            Path toTest = new File(projectPath + Push.getPATH_CORRECTED_FILES(), p.toString()).toPath();
            Path toTest2 = new File(correctedTestPath, p.toString()).toPath();
            if (!toTest2.getParent().toFile().exists()) {
                toTest2.getParent().toFile().mkdirs();
            }
            Files.move(toTest, toTest2, new CopyOption[0]);
        }
    }

    public static void publishMoodle(String projectPath, String vplId, String token, String url) throws IOException, ClassNotFoundException, VplException {
        String[] ids = vplId.split(",");
        if (vplId != null) {
            for (String id : ids) {
                RestJsonMoodleClient client = new RestJsonMoodleClient(id, token, url);
                client.setServerSupportsIsBinary(true);
                Push.saveFiles(client, projectPath + Push.getPATH_REQUESTED_FILES(), RestJsonMoodleClient.VPLService.VPL_SAVE_RF);
                Push.saveFiles(client, projectPath + Push.getPATH_EXECUTION_FILES(), RestJsonMoodleClient.VPLService.VPL_SAVE_EF);
                Push.saveFiles(client, projectPath + Push.getPATH_CORRECTED_FILES(), RestJsonMoodleClient.VPLService.VPL_SAVE_CF);
            }
        }
    }

    private static void saveFiles(RestJsonMoodleClient client, String projectLocation, RestJsonMoodleClient.VPLService service) throws IOException, VplException {
        List files = FileUtils.listFiles((String)projectLocation);
        if (files == null) {
            System.out.println("Directory " + projectLocation + " not found");
        } else if (files.isEmpty()) {
            System.out.println("No files found in " + projectLocation);
        } else {
            Stream<VplFile> vplFiles = files.stream().map(file -> Push.fileToCaseinePath(file, projectLocation));
            JsonObject result = client.callServiceWithFiles(service.toString(), vplFiles.collect(Collectors.toList()));
            System.out.println(result);
        }
    }

    private static VplFile fileToCaseinePath(File f, String projectLocation) {
        String fProjectRelativeName;
        if (!((String)(projectLocation = new File((String)projectLocation).getAbsolutePath())).endsWith(File.separator)) {
            projectLocation = (String)projectLocation + File.separator;
        }
        if ((fProjectRelativeName = f.getAbsolutePath().replace((CharSequence)projectLocation, "").replace(File.separator, "/")).startsWith(PATH_SRC + "/")) {
            fProjectRelativeName = fProjectRelativeName.substring(PATH_SRC.length() + 1);
        }
        try {
            return new VplFile(f, fProjectRelativeName);
        }
        catch (IOException e) {
            return null;
        }
    }

    public static void clean(String projectPath) throws IOException {
        if (!new File(projectPath + PATH_SRC).exists()) {
            throw new FileNotFoundException("Directory \"" + projectPath + PATH_SRC + "\" does not exist");
        }
        if (!new File(projectPath + Push.getPATH_BIN()).exists()) {
            throw new FileNotFoundException("Directory \"" + projectPath + Push.getPATH_BIN() + "\" does not exist, compile the project first");
        }
        if (new File(projectPath + Push.getPATH_OUTPUT()).exists()) {
            Path folder = Paths.get(projectPath + Push.getPATH_OUTPUT(), new String[0]);
            CleanFolder.clean(folder);
        }
    }

    private static String getPATH_REQUESTED_FILES() {
        return Push.getPATH_OUTPUT() + File.separator + RF + File.separator;
    }

    private static String getPATH_CORRECTED_FILES() {
        return Push.getPATH_OUTPUT() + File.separator + CF + File.separator;
    }

    private static String getPATH_EXECUTION_FILES() {
        return Push.getPATH_OUTPUT() + File.separator + EF + File.separator;
    }

    private static String getPATH_OUTPUT() {
        return Push.getPATH_BIN() + "caseine-output";
    }

    public static boolean isGenerated(String projectPath) {
        return new File(projectPath + Push.getPATH_OUTPUT()).exists();
    }

    public static void listDirectory(File file, String prefix, List<String> liste) {
        if (file.exists()) {
            if (file.isFile() && file.getName().endsWith(".java")) {
                liste.add(prefix + file.getName().substring(0, file.getName().length() - 5));
            } else if (file.isDirectory() && !file.getName().startsWith(CF)) {
                File[] contenu = file.listFiles();
                for (int i = 0; i < contenu.length; ++i) {
                    Object pref = prefix;
                    if (!file.getName().equals(EF)) {
                        pref = (String)pref + file.getName() + ".";
                    }
                    Push.listDirectory(contenu[i], (String)pref, liste);
                }
            }
        }
    }

    private static String getPATH_BIN() {
        return PATH_BIN;
    }

    static {
        options.addOption("h", "help", false, "Prints usage and exits. ");
        options.addOption("v", "vplId", true, "specify the vplid. If unspecified, only generate gaseine files.");
        PATH_BIN = File.separator + "target" + File.separator;
    }
}

