/*
 * Decompiled with CFR 0.152.
 */
package caseine.project;

import caseine.CleanFolder;
import caseine.FileUtils;
import caseine.exceptions.TestDirectoryMissingException;
import caseine.exceptions.UnitTestsFileMissingException;
import caseine.project.BadIDEException;
import caseine.project.CaseineJavaProject;
import caseine.project.CaseineProject;
import caseine.project.CaseineProjectAlreadyExistingException;
import caseine.project.FileMissingException;
import caseine.project.MavenProjectException;
import caseine.project.NothingPushedException;
import caseine.project.VPLIDMissingException;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.json.JsonObject;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import vplwsclient.RestJsonMoodleClient;
import vplwsclient.VplFile;
import vplwsclient.exception.MoodleWebServiceException;
import vplwsclient.exception.VplConnectionException;
import vplwsclient.exception.VplException;

public class CaseineCommonProject
implements CaseineProject {
    private static final String CASEINE_COMMENT = "For settings, see https://moodle.caseine.org/mod/wiki/view.php?pageid=199\nWritable settings are:\n - WS.name, WS.shortdescription, WS.intro, WS.introformat, WS.startdate\n - WS.duedate, WS.maxfiles, WS.maxfilesize, WS.requirednet, WS.password\n - WS.grade, WS.visiblegrade, WS.usevariations, WS.variationtitle\n - WS.usableasbase, WS.basedon, WS.run, WS.debug, WS.evaluate\n - WS.evaluateonsubmission, WS.automaticgrading, WS.usegradefrom\n - WS.maxexetime, WS.restrictededitor, WS.allowsubmissionviaeditor\n - WS.forbiddeneditors, WS.example, WS.maxexememory, WS.maxexefilesize\n - WS.maxexeprocesses, WS.jailservers, WS.worktype, WS.emailteachers\n - WS.timemodified, WS.freeevaluations, WS.reductionbyevaluation\n - WS.sebrequired, WS.sebkeys, WS.runscript, WS.debugscript";
    protected static final String VPLID_0 = "0";
    public static String CASEINE_VPL_ID = "CASEINE_VPL_ID";
    public static String CASEINE_VPL_TYPE = "CASEINE_VPL_TYPE";
    protected String projectPath;
    protected String vplId;
    protected File caseineFile;
    protected static String INTERNAL_FILE = ".caseine";
    protected static Logger log = Logger.getLogger(CaseineJavaProject.class.getName());
    private String url;
    private String token;
    protected static final String RF = "rf";
    protected static final String EF = "ef";
    protected static final String CF = "cf";
    protected static final String PATH_SRC = File.separator + "src";
    protected static final String PATH_CLASSES = File.separator + "target" + File.separator + "classes";
    protected static final String PATH_DOC = File.separator + "doc";
    protected static String PATH_BIN = File.separator + "target" + File.separator;
    protected static final String PATH_TEST = File.separator + "test";
    protected static final String PATH_RESOURCES_SRC = File.separator + "resources" + File.separator + "src";
    protected static final String PATH_RESOURCES_TEST = File.separator + "resources" + File.separator + "test";
    protected static final String PATH_RESOURCES_LIB = File.separator + "resources" + File.separator + "lib";
    protected static final String PLUGIN_LIB = "caseine.vpl.tools.plugin.jar";
    protected boolean settings = false;

    public CaseineCommonProject(String projectPath, String vplId, String url, String token, boolean settings) {
        this.projectPath = projectPath;
        this.caseineFile = new File(projectPath + File.separator + INTERNAL_FILE);
        this.vplId = vplId;
        this.url = url;
        this.token = token;
        this.settings = settings;
    }

    @Override
    public boolean isCaseine() {
        boolean result = false;
        if (this.getType() == CaseineProject.ProjectType.MAVEN) {
            result = true;
        }
        if (this.caseineFile.exists()) {
            result = true;
        }
        return result;
    }

    @Override
    public CaseineProject.ProjectType getType() {
        Properties props;
        CaseineProject.ProjectType result = CaseineProject.ProjectType.JAVA;
        File pom = new File(this.projectPath + File.separator + "pom.xml");
        if (pom.exists()) {
            result = CaseineProject.ProjectType.MAVEN;
        }
        if ((props = this.getProperties()).containsKey(CASEINE_VPL_TYPE)) {
            String type = (String)props.get(CASEINE_VPL_TYPE);
            result = CaseineProject.ProjectType.valueOf(type);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Properties getProperties() {
        Properties props = new Properties();
        if (this.caseineFile.exists()) {
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(this.caseineFile);
                props.load(fis);
            }
            catch (Exception e) {
                log.severe(e.getMessage());
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException e) {
                        log.severe(e.getMessage());
                    }
                }
            }
        }
        return props;
    }

    @Override
    public String getVplId() {
        String result = null;
        if (this.caseineFile.exists()) {
            Properties props = this.getProperties();
            if (props.containsKey(CASEINE_VPL_ID)) {
                result = (String)props.get(CASEINE_VPL_ID);
            }
        } else if (this.getType() == CaseineProject.ProjectType.MAVEN) {
            File pom = new File(this.projectPath + File.separator + "pom.xml");
            MavenXpp3Reader reader = new MavenXpp3Reader();
            try {
                Model model = reader.read((Reader)new FileReader(pom));
                Properties properties = model.getProperties();
                result = (String)properties.get(CASEINE_VPL_ID);
            }
            catch (IOException | XmlPullParserException throwable) {
                // empty catch block
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fillCaseine(String vplId) {
        if (this.caseineFile.exists()) {
            Properties props = new Properties();
            FileInputStream fis = null;
            FileOutputStream fos = null;
            try {
                fis = new FileInputStream(this.caseineFile);
                props.load(fis);
                if (!vplId.equals(VPLID_0)) {
                    props.setProperty(CASEINE_VPL_ID, vplId);
                }
                props.setProperty(CASEINE_VPL_TYPE, this.getType().toString());
                fos = new FileOutputStream(this.caseineFile);
                props.store(fos, CASEINE_COMMENT);
            }
            catch (Exception e) {
                log.severe(e.getMessage());
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException e) {
                        log.severe(e.getMessage());
                    }
                }
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (IOException e) {
                        log.severe(e.getMessage());
                    }
                }
            }
        }
    }

    @Override
    public void generate(boolean mvn, int template) throws CaseineProjectAlreadyExistingException, BadIDEException, IOException, TestDirectoryMissingException, FileMissingException, UnitTestsFileMissingException {
    }

    @Override
    public void local(ClassLoader cl) throws IOException, ClassNotFoundException, MavenProjectException {
    }

    @Override
    public void push(ClassLoader cl) throws IOException, ClassNotFoundException, VplException, VPLIDMissingException, MavenProjectException, NothingPushedException {
        boolean somethingPushed = false;
        this.local(cl);
        this.vplId = this.getVplId();
        if (this.vplId != null) {
            String[] ids;
            if (this.settings) {
                somethingPushed |= this.updateSettings();
            }
            for (String id : ids = this.vplId.split(",")) {
                RestJsonMoodleClient client = new RestJsonMoodleClient(id, this.token, this.url);
                client.setServerSupportsIsBinary(true);
                somethingPushed = CaseineCommonProject.saveFiles(client, this.projectPath + CaseineCommonProject.getPATH_REQUESTED_FILES(), RestJsonMoodleClient.VPLService.VPL_SAVE_RF, true, true);
                somethingPushed |= CaseineCommonProject.saveFiles(client, this.projectPath + CaseineCommonProject.getPATH_EXECUTION_FILES(), RestJsonMoodleClient.VPLService.VPL_SAVE_EF, true, false);
                somethingPushed |= CaseineCommonProject.saveFiles(client, this.projectPath + CaseineCommonProject.getPATH_CORRECTED_FILES(), RestJsonMoodleClient.VPLService.VPL_SAVE_CF, true, true);
            }
            somethingPushed |= this.documentation();
        }
        if (!somethingPushed) {
            throw new NothingPushedException("Nothing pushed on the server : a VPL_ID is needed");
        }
    }

    @Override
    public void clean() throws IOException {
        new File(this.projectPath + CaseineCommonProject.getPATH_BIN()).mkdir();
        if (new File(this.projectPath + CaseineCommonProject.getPATH_OUTPUT()).exists()) {
            Path folder = Paths.get(this.projectPath + CaseineCommonProject.getPATH_OUTPUT(), new String[0]);
            CleanFolder.clean(folder);
        }
    }

    @Override
    public boolean isGenerated() {
        return new File(this.projectPath + CaseineCommonProject.getPATH_OUTPUT()).exists();
    }

    @Override
    public void nature() throws CaseineProjectAlreadyExistingException, IOException {
        if (this.isCaseine()) {
            if (this.getType() == CaseineProject.ProjectType.MAVEN) {
                throw new CaseineProjectAlreadyExistingException("Nature command is not implemented for Maven projects");
            }
            throw new CaseineProjectAlreadyExistingException("A project already exists in " + this.projectPath);
        }
        if (!this.caseineFile.createNewFile()) {
            log.severe(".caseine cannot be created");
        }
        this.fillCaseine(this.vplId);
    }

    @Override
    public boolean documentation() throws VplConnectionException, MoodleWebServiceException, IOException {
        boolean somethingPushed = false;
        this.vplId = this.getVplId();
        if (this.vplId != null) {
            String[] ids;
            for (String id : ids = this.vplId.split(",")) {
                RestJsonMoodleClient client = new RestJsonMoodleClient(id, this.token, this.url);
                client.setServerSupportsIsBinary(true);
                JsonObject introObject = client.callService("mod_vpl_get_setting", new String[]{"settingname", "introformat"});
                String format = introObject.getString("value");
                String filePath = this.projectPath + PATH_DOC;
                String fileName = filePath + File.separator + "intro";
                if (format.equals("1")) {
                    fileName = fileName + ".html";
                }
                File doc = new File(fileName);
                File docDir = new File(filePath);
                if (doc.exists()) {
                    String introduction = Files.readString(Path.of(fileName, new String[0]));
                    client.callService("mod_vpl_set_setting", new String[]{"settingname", "intro", "settingvalue", introduction});
                    somethingPushed = true;
                    continue;
                }
                docDir.mkdir();
                JsonObject intro = client.callService("mod_vpl_info", new String[0]);
                String introHtml = intro.getString("intro", "A problem occured while recovering the VPL description.");
                try (BufferedWriter writer = new BufferedWriter(new FileWriter(fileName));){
                    writer.write(introHtml);
                }
            }
        }
        return somethingPushed;
    }

    @Override
    public boolean updateSettings() throws VplConnectionException, MoodleWebServiceException, IOException {
        this.vplId = this.getVplId();
        Properties properties = this.getProperties();
        if (this.vplId != null) {
            String[] ids;
            for (String id : ids = this.vplId.split(",")) {
                RestJsonMoodleClient client = new RestJsonMoodleClient(id, this.token, this.url);
                client.setServerSupportsIsBinary(true);
                properties.keySet().stream().filter(key -> key.toString().startsWith("WS.")).forEach(name -> {
                    try {
                        String settingName = name.toString().substring(3);
                        String settingValue = properties.get(name).toString();
                        log.info(String.format("Trying to update setting %s with value %s", settingName, settingValue));
                        client.callService("mod_vpl_set_setting", new String[]{"settingname", settingName, "settingvalue", settingValue});
                    }
                    catch (MoodleWebServiceException | VplConnectionException e) {
                        log.severe(e.getMessage());
                    }
                });
            }
        }
        return !properties.keySet().isEmpty();
    }

    protected static String getPATH_REQUESTED_FILES() {
        return CaseineCommonProject.getPATH_OUTPUT() + File.separator + RF + File.separator;
    }

    protected static String getPATH_CORRECTED_FILES() {
        return CaseineCommonProject.getPATH_OUTPUT() + File.separator + CF + File.separator;
    }

    protected static String getPATH_EXECUTION_FILES() {
        return CaseineCommonProject.getPATH_OUTPUT() + File.separator + EF + File.separator;
    }

    protected static String getPATH_OUTPUT() {
        return CaseineCommonProject.getPATH_BIN() + "caseine-output";
    }

    protected static String getPATH_BIN() {
        return PATH_BIN;
    }

    private static boolean saveFiles(RestJsonMoodleClient client, String projectLocation, RestJsonMoodleClient.VPLService service, boolean override, boolean checkMax) throws IOException, VplException {
        boolean somethingPushed = false;
        List files = vplwsclient.FileUtils.listFiles((String)projectLocation);
        if (files == null) {
            System.out.println("Directory " + projectLocation + " not found");
        } else if (files.isEmpty()) {
            System.out.println("No files found in " + projectLocation);
        } else {
            Stream<VplFile> vplFiles = files.stream().map(file -> CaseineCommonProject.fileToCaseinePath(file, projectLocation));
            somethingPushed = !files.isEmpty();
            JsonObject result = client.callServiceWithFiles(service.toString(), vplFiles.collect(Collectors.toList()));
            System.out.println((Object)(result == null ? "Ok" : result));
        }
        return somethingPushed;
    }

    protected void fillCaseineProjectFile() {
        try {
            FileUtils.fillTemplate((String)(this.projectPath + File.separatorChar + ".project"), (String)"/*VPL_NAME*/", (String)this.getProjectName());
        }
        catch (IOException e) {
            log.severe(e.getMessage());
        }
    }

    protected static VplFile fileToCaseinePath(File f, String projectLocation) {
        String fProjectRelativeName;
        if (!((String)(projectLocation = new File((String)projectLocation).getAbsolutePath())).endsWith(File.separator)) {
            projectLocation = (String)projectLocation + File.separator;
        }
        if ((fProjectRelativeName = f.getAbsolutePath().replace((CharSequence)projectLocation, "").replace(File.separator, "/")).startsWith(PATH_SRC + "/")) {
            fProjectRelativeName = fProjectRelativeName.substring(PATH_SRC.length() + 1);
        }
        try {
            return new VplFile(f, fProjectRelativeName);
        }
        catch (IOException e) {
            return null;
        }
    }

    public String getProjectName() {
        String projectName = null;
        File projectFile = new File(this.projectPath);
        projectName = this.projectPath.endsWith(".") ? projectFile.getParentFile().getName() : projectFile.getName();
        return projectName;
    }
}

