/*
 * Decompiled with CFR 0.152.
 */
package caseine.project;

import caseine.CppLauncher;
import caseine.exceptions.MissingVplEvaluateCaseFileException;
import caseine.exceptions.RootFileNotEmptyException;
import caseine.exceptions.TestDirectoryMissingException;
import caseine.exceptions.UnitTestsFileMissingException;
import caseine.project.BadIDEException;
import caseine.project.CaseineCommonProject;
import caseine.project.CaseineProject;
import caseine.project.CaseineProjectAlreadyExistingException;
import caseine.project.FileMissingException;
import caseine.project.MavenProjectException;
import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;

public class CaseineCppProject
extends CaseineCommonProject
implements CaseineProject {
    public CaseineCppProject(String projectPath, String vplId, String url, String token, boolean settings) {
        super(projectPath, vplId, url, token, settings);
    }

    @Override
    public CaseineProject.ProjectType getType() {
        return CaseineProject.ProjectType.CPP;
    }

    @Override
    public void generate(boolean mvn, int template) throws CaseineProjectAlreadyExistingException, BadIDEException, IOException, TestDirectoryMissingException, FileMissingException, UnitTestsFileMissingException {
        if (this.isCaseine()) {
            throw new CaseineProjectAlreadyExistingException("A project already exists in " + this.projectPath);
        }
        File root = new File(this.projectPath);
        if (!root.exists()) {
            root.mkdir();
        }
        try {
            CppLauncher.launch((String)this.projectPath, (int)template);
        }
        catch (MissingVplEvaluateCaseFileException | RootFileNotEmptyException | IOException e) {
            e.printStackTrace();
        }
        this.fillCaseine(this.vplId);
        this.fillCaseineProjectFile();
    }

    private void checkRoot(File root) {
    }

    @Override
    public void local(ClassLoader cl) throws IOException, ClassNotFoundException, MavenProjectException {
        if (this.vplId.equals("0")) {
            this.vplId = this.getVplId();
        } else {
            this.fillCaseine(this.vplId);
        }
        this.clean();
        try {
            CppLauncher.launch((String)Paths.get(this.projectPath, new String[0]).toAbsolutePath().toString());
        }
        catch (Exception ex) {
            System.err.println(ex.getMessage());
        }
    }
}

