/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.auth;

import org.apache.cassandra.auth.IResource;
import org.apache.cassandra.config.Schema;
import org.apache.commons.lang3.StringUtils;
import org.cassandraunit.shaded.com.google.common.base.Objects;

public class DataResource
implements IResource {
    private static final String ROOT_NAME = "data";
    private static final DataResource ROOT_RESOURCE = new DataResource();
    private final Level level;
    private final String keyspace;
    private final String columnFamily;

    private DataResource() {
        this.level = Level.ROOT;
        this.keyspace = null;
        this.columnFamily = null;
    }

    private DataResource(String keyspace) {
        this.level = Level.KEYSPACE;
        this.keyspace = keyspace;
        this.columnFamily = null;
    }

    private DataResource(String keyspace, String columnFamily) {
        this.level = Level.COLUMN_FAMILY;
        this.keyspace = keyspace;
        this.columnFamily = columnFamily;
    }

    public static DataResource root() {
        return ROOT_RESOURCE;
    }

    public static DataResource keyspace(String keyspace) {
        return new DataResource(keyspace);
    }

    public static DataResource columnFamily(String keyspace, String columnFamily) {
        return new DataResource(keyspace, columnFamily);
    }

    public static DataResource fromName(String name) {
        String[] parts = StringUtils.split((String)name, (char)'/');
        if (!parts[0].equals(ROOT_NAME) || parts.length > 3) {
            throw new IllegalArgumentException(String.format("%s is not a valid data resource name", name));
        }
        if (parts.length == 1) {
            return DataResource.root();
        }
        if (parts.length == 2) {
            return DataResource.keyspace(parts[1]);
        }
        return DataResource.columnFamily(parts[1], parts[2]);
    }

    @Override
    public String getName() {
        switch (this.level) {
            case ROOT: {
                return ROOT_NAME;
            }
            case KEYSPACE: {
                return String.format("%s/%s", ROOT_NAME, this.keyspace);
            }
            case COLUMN_FAMILY: {
                return String.format("%s/%s/%s", ROOT_NAME, this.keyspace, this.columnFamily);
            }
        }
        throw new AssertionError();
    }

    @Override
    public IResource getParent() {
        switch (this.level) {
            case KEYSPACE: {
                return DataResource.root();
            }
            case COLUMN_FAMILY: {
                return DataResource.keyspace(this.keyspace);
            }
        }
        throw new IllegalStateException("Root-level resource can't have a parent");
    }

    public boolean isRootLevel() {
        return this.level.equals((Object)Level.ROOT);
    }

    public boolean isKeyspaceLevel() {
        return this.level.equals((Object)Level.KEYSPACE);
    }

    public boolean isColumnFamilyLevel() {
        return this.level.equals((Object)Level.COLUMN_FAMILY);
    }

    public String getKeyspace() {
        if (this.isRootLevel()) {
            throw new IllegalStateException("ROOT data resource has no keyspace");
        }
        return this.keyspace;
    }

    public String getColumnFamily() {
        if (!this.isColumnFamilyLevel()) {
            throw new IllegalStateException(String.format("%s data resource has no column family", new Object[]{this.level}));
        }
        return this.columnFamily;
    }

    @Override
    public boolean hasParent() {
        return !this.level.equals((Object)Level.ROOT);
    }

    @Override
    public boolean exists() {
        switch (this.level) {
            case ROOT: {
                return true;
            }
            case KEYSPACE: {
                return Schema.instance.getKeyspaces().contains(this.keyspace);
            }
            case COLUMN_FAMILY: {
                return Schema.instance.getCFMetaData(this.keyspace, this.columnFamily) != null;
            }
        }
        throw new AssertionError();
    }

    public String toString() {
        switch (this.level) {
            case ROOT: {
                return "<all keyspaces>";
            }
            case KEYSPACE: {
                return String.format("<keyspace %s>", this.keyspace);
            }
            case COLUMN_FAMILY: {
                return String.format("<table %s.%s>", this.keyspace, this.columnFamily);
            }
        }
        throw new AssertionError();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DataResource)) {
            return false;
        }
        DataResource ds = (DataResource)o;
        return Objects.equal((Object)this.level, (Object)ds.level) && Objects.equal(this.keyspace, ds.keyspace) && Objects.equal(this.columnFamily, ds.columnFamily);
    }

    public int hashCode() {
        return Objects.hashCode(new Object[]{this.level, this.keyspace, this.columnFamily});
    }

    static enum Level {
        ROOT,
        KEYSPACE,
        COLUMN_FAMILY;

    }
}

