/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.config;

import java.beans.IntrospectionException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.cassandra.config.Config;
import org.apache.cassandra.config.ConfigurationLoader;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.config.SeedProviderDef;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.cassandraunit.shaded.com.google.common.base.Joiner;
import org.cassandraunit.shaded.com.google.common.io.ByteStreams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.TypeDescription;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Constructor;
import org.yaml.snakeyaml.error.YAMLException;
import org.yaml.snakeyaml.introspector.MissingProperty;
import org.yaml.snakeyaml.introspector.Property;
import org.yaml.snakeyaml.introspector.PropertyUtils;

public class YamlConfigurationLoader
implements ConfigurationLoader {
    private static final Logger logger = LoggerFactory.getLogger(YamlConfigurationLoader.class);
    private static final String DEFAULT_CONFIGURATION = "cassandra.yaml";

    static URL getStorageConfigURL() throws ConfigurationException {
        URL url;
        block4: {
            String configUrl = System.getProperty("cassandra.config");
            if (configUrl == null) {
                configUrl = DEFAULT_CONFIGURATION;
            }
            try {
                url = new URL(configUrl);
                url.openStream().close();
            }
            catch (Exception e) {
                ClassLoader loader = DatabaseDescriptor.class.getClassLoader();
                url = loader.getResource(configUrl);
                if (url != null) break block4;
                String required = "file:" + File.separator + File.separator;
                if (!configUrl.startsWith(required)) {
                    throw new ConfigurationException("Expecting URI in variable: [cassandra.config].  Please prefix the file with " + required + File.separator + " for local files or " + required + "<server>" + File.separator + " for remote files. Aborting. If you are executing this from an external tool, it needs to set Config.setClientMode(true) to avoid loading configuration.");
                }
                throw new ConfigurationException("Cannot locate " + configUrl + ".  If this is a local file, please confirm you've provided " + required + File.separator + " as a URI prefix.");
            }
        }
        return url;
    }

    @Override
    public Config loadConfig() throws ConfigurationException {
        return this.loadConfig(YamlConfigurationLoader.getStorageConfigURL());
    }

    public Config loadConfig(URL url) throws ConfigurationException {
        Object input = null;
        try {
            byte[] configBytes;
            logger.info("Loading settings from {}", (Object)url);
            try (InputStream is = url.openStream();){
                configBytes = ByteStreams.toByteArray(is);
            }
            catch (IOException e) {
                throw new AssertionError((Object)e);
            }
            this.logConfig(configBytes);
            Constructor constructor = new Constructor(Config.class);
            TypeDescription seedDesc = new TypeDescription(SeedProviderDef.class);
            seedDesc.putMapPropertyType("parameters", String.class, String.class);
            constructor.addTypeDescription(seedDesc);
            MissingPropertiesChecker propertiesChecker = new MissingPropertiesChecker();
            constructor.setPropertyUtils((PropertyUtils)propertiesChecker);
            Yaml yaml = new Yaml((BaseConstructor)constructor);
            Config result = (Config)yaml.loadAs((InputStream)new ByteArrayInputStream(configBytes), Config.class);
            result.configHintedHandoff();
            propertiesChecker.check();
            return result;
        }
        catch (YAMLException e) {
            throw new ConfigurationException("Invalid yaml", e);
        }
    }

    private void logConfig(byte[] configBytes) {
        TreeMap<String, String> configMap = new TreeMap<String, String>((Map)new Yaml().load((InputStream)new ByteArrayInputStream(configBytes)));
        for (String sensitiveKey : new String[]{"client_encryption_options", "server_encryption_options"}) {
            if (!configMap.containsKey(sensitiveKey)) continue;
            configMap.put(sensitiveKey, "<REDACTED>");
        }
        logger.info("Node configuration:[" + Joiner.on("; ").join(configMap.entrySet()) + "]");
    }

    private static class MissingPropertiesChecker
    extends PropertyUtils {
        private final Set<String> missingProperties = new HashSet<String>();

        public MissingPropertiesChecker() {
            this.setSkipMissingProperties(true);
        }

        public Property getProperty(Class<? extends Object> type, String name) throws IntrospectionException {
            Property result = super.getProperty(type, name);
            if (result instanceof MissingProperty) {
                this.missingProperties.add(result.getName());
            }
            return result;
        }

        public void check() throws ConfigurationException {
            if (!this.missingProperties.isEmpty()) {
                throw new ConfigurationException("Invalid yaml. Please remove properties " + this.missingProperties + " from your cassandra.yaml");
            }
        }
    }
}

