/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.statements;

import org.apache.cassandra.auth.Permission;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.cql3.statements.KSPropDefs;
import org.apache.cassandra.cql3.statements.SchemaAlteringStatement;
import org.apache.cassandra.exceptions.AlreadyExistsException;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.exceptions.RequestValidationException;
import org.apache.cassandra.exceptions.UnauthorizedException;
import org.apache.cassandra.locator.AbstractReplicationStrategy;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.service.MigrationManager;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.transport.Event;
import org.cassandraunit.shaded.org.apache.cassandra.thrift.ThriftValidation;

public class CreateKeyspaceStatement
extends SchemaAlteringStatement {
    private final String name;
    private final KSPropDefs attrs;
    private final boolean ifNotExists;

    public CreateKeyspaceStatement(String name, KSPropDefs attrs, boolean ifNotExists) {
        this.name = name;
        this.attrs = attrs;
        this.ifNotExists = ifNotExists;
    }

    @Override
    public String keyspace() {
        return this.name;
    }

    @Override
    public void checkAccess(ClientState state) throws UnauthorizedException {
        state.hasAllKeyspacesAccess(Permission.CREATE);
    }

    @Override
    public void validate(ClientState state) throws RequestValidationException {
        ThriftValidation.validateKeyspaceNotSystem(this.name);
        if (!this.name.matches("\\w+")) {
            throw new InvalidRequestException(String.format("\"%s\" is not a valid keyspace name", this.name));
        }
        if (this.name.length() > 48) {
            throw new InvalidRequestException(String.format("Keyspace names shouldn't be more than %s characters long (got \"%s\")", 48, this.name));
        }
        this.attrs.validate();
        if (this.attrs.getReplicationStrategyClass() == null) {
            throw new ConfigurationException("Missing mandatory replication strategy class");
        }
        AbstractReplicationStrategy.validateReplicationStrategy(this.name, AbstractReplicationStrategy.getClass(this.attrs.getReplicationStrategyClass()), StorageService.instance.getTokenMetadata(), DatabaseDescriptor.getEndpointSnitch(), this.attrs.getReplicationOptions());
    }

    @Override
    public boolean announceMigration(boolean isLocalOnly) throws RequestValidationException {
        try {
            MigrationManager.announceNewKeyspace(this.attrs.asKSMetadata(this.name), isLocalOnly);
            return true;
        }
        catch (AlreadyExistsException e) {
            if (this.ifNotExists) {
                return false;
            }
            throw e;
        }
    }

    @Override
    public Event.SchemaChange changeEvent() {
        return new Event.SchemaChange(Event.SchemaChange.Change.CREATED, this.keyspace());
    }
}

