/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.io.DataInput;
import java.io.IOException;
import org.apache.cassandra.cache.IMeasurableMemory;
import org.apache.cassandra.db.OnDiskAtom;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.io.ISerializer;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.utils.ObjectSizes;
import org.cassandraunit.shaded.com.google.common.annotations.VisibleForTesting;
import org.cassandraunit.shaded.com.google.common.base.Objects;
import org.cassandraunit.shaded.org.codehaus.jackson.annotate.JsonIgnore;

public class DeletionTime
implements Comparable<DeletionTime>,
IMeasurableMemory {
    private static final long EMPTY_SIZE = ObjectSizes.measure(new DeletionTime(0L, 0));
    public static final DeletionTime LIVE = new DeletionTime(Long.MIN_VALUE, Integer.MAX_VALUE);
    public final long markedForDeleteAt;
    public final int localDeletionTime;
    public static final Serializer serializer = new Serializer();

    @VisibleForTesting
    public DeletionTime(long markedForDeleteAt, int localDeletionTime) {
        this.markedForDeleteAt = markedForDeleteAt;
        this.localDeletionTime = localDeletionTime;
    }

    @JsonIgnore
    public boolean isLive() {
        return this.markedForDeleteAt == Long.MIN_VALUE && this.localDeletionTime == Integer.MAX_VALUE;
    }

    public boolean equals(Object o) {
        if (!(o instanceof DeletionTime)) {
            return false;
        }
        DeletionTime that = (DeletionTime)o;
        return this.markedForDeleteAt == that.markedForDeleteAt && this.localDeletionTime == that.localDeletionTime;
    }

    public final int hashCode() {
        return Objects.hashCode(this.markedForDeleteAt, this.localDeletionTime);
    }

    public String toString() {
        return String.format("deletedAt=%d, localDeletion=%d", this.markedForDeleteAt, this.localDeletionTime);
    }

    @Override
    public int compareTo(DeletionTime dt) {
        if (this.markedForDeleteAt < dt.markedForDeleteAt) {
            return -1;
        }
        if (this.markedForDeleteAt > dt.markedForDeleteAt) {
            return 1;
        }
        if (this.localDeletionTime < dt.localDeletionTime) {
            return -1;
        }
        if (this.localDeletionTime > dt.localDeletionTime) {
            return -1;
        }
        return 0;
    }

    public boolean isGcAble(int gcBefore) {
        return this.localDeletionTime < gcBefore;
    }

    public boolean isDeleted(OnDiskAtom atom) {
        return atom.timestamp() <= this.markedForDeleteAt;
    }

    public boolean supersedes(DeletionTime dt) {
        return this.markedForDeleteAt > dt.markedForDeleteAt;
    }

    @Override
    public long unsharedHeapSize() {
        return EMPTY_SIZE;
    }

    public static class Serializer
    implements ISerializer<DeletionTime> {
        @Override
        public void serialize(DeletionTime delTime, DataOutputPlus out) throws IOException {
            out.writeInt(delTime.localDeletionTime);
            out.writeLong(delTime.markedForDeleteAt);
        }

        @Override
        public DeletionTime deserialize(DataInput in) throws IOException {
            int ldt = in.readInt();
            long mfda = in.readLong();
            return mfda == Long.MIN_VALUE && ldt == Integer.MAX_VALUE ? LIVE : new DeletionTime(mfda, ldt);
        }

        public void skip(DataInput in) throws IOException {
            FileUtils.skipBytesFully(in, 12);
        }

        @Override
        public long serializedSize(DeletionTime delTime, TypeSizes typeSizes) {
            return typeSizes.sizeof(delTime.localDeletionTime) + typeSizes.sizeof(delTime.markedForDeleteAt);
        }
    }
}

