/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.filter;

import java.io.DataInput;
import java.io.IOException;
import java.util.Comparator;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.cassandra.db.Cell;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.DeletionInfo;
import org.apache.cassandra.db.OnDiskAtom;
import org.apache.cassandra.db.RangeTombstone;
import org.apache.cassandra.db.RowIndexEntry;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.db.columniterator.OnDiskAtomIterator;
import org.apache.cassandra.db.columniterator.SSTableNamesIterator;
import org.apache.cassandra.db.composites.CType;
import org.apache.cassandra.db.composites.CellName;
import org.apache.cassandra.db.composites.CellNameType;
import org.apache.cassandra.db.composites.Composite;
import org.apache.cassandra.db.filter.ColumnCounter;
import org.apache.cassandra.db.filter.ColumnSlice;
import org.apache.cassandra.db.filter.IDiskAtomFilter;
import org.apache.cassandra.io.ISerializer;
import org.apache.cassandra.io.IVersionedSerializer;
import org.apache.cassandra.io.sstable.SSTableReader;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.io.util.FileDataInput;
import org.apache.commons.lang3.StringUtils;
import org.cassandraunit.shaded.com.google.common.collect.AbstractIterator;
import org.cassandraunit.shaded.com.google.common.collect.Iterators;

public class NamesQueryFilter
implements IDiskAtomFilter {
    public final SortedSet<CellName> columns;
    private final boolean countCQL3Rows;

    public NamesQueryFilter(SortedSet<CellName> columns) {
        this(columns, false);
    }

    public NamesQueryFilter(SortedSet<CellName> columns, boolean countCQL3Rows) {
        this.columns = columns;
        this.countCQL3Rows = countCQL3Rows;
    }

    @Override
    public NamesQueryFilter cloneShallow() {
        return this;
    }

    public NamesQueryFilter withUpdatedColumns(SortedSet<CellName> newColumns) {
        return new NamesQueryFilter(newColumns, this.countCQL3Rows);
    }

    @Override
    public Iterator<Cell> getColumnIterator(ColumnFamily cf) {
        assert (cf != null);
        return new ByNameColumnIterator(this.columns.iterator(), null, cf);
    }

    @Override
    public OnDiskAtomIterator getColumnIterator(DecoratedKey key, ColumnFamily cf) {
        assert (cf != null);
        return new ByNameColumnIterator(this.columns.iterator(), key, cf);
    }

    @Override
    public OnDiskAtomIterator getSSTableColumnIterator(SSTableReader sstable, DecoratedKey key) {
        return new SSTableNamesIterator(sstable, key, this.columns);
    }

    @Override
    public OnDiskAtomIterator getSSTableColumnIterator(SSTableReader sstable, FileDataInput file, DecoratedKey key, RowIndexEntry indexEntry) {
        return new SSTableNamesIterator(sstable, file, key, this.columns, indexEntry);
    }

    @Override
    public void collectReducedColumns(ColumnFamily container, Iterator<Cell> reducedColumns, DecoratedKey key, int gcBefore, long now) {
        DeletionInfo.InOrderTester tester = container.inOrderDeletionTester();
        while (reducedColumns.hasNext()) {
            container.maybeAppendColumn(reducedColumns.next(), tester, gcBefore);
        }
    }

    @Override
    public Comparator<Cell> getColumnComparator(CellNameType comparator) {
        return comparator.columnComparator(false);
    }

    public String toString() {
        return "NamesQueryFilter(columns=" + StringUtils.join(this.columns, (String)",") + ')';
    }

    @Override
    public boolean isReversed() {
        return false;
    }

    @Override
    public void updateColumnsLimit(int newLimit) {
    }

    @Override
    public int getLiveCount(ColumnFamily cf, long now) {
        if (this.countCQL3Rows) {
            return cf.hasOnlyTombstones(now) ? 0 : 1;
        }
        int count = 0;
        for (Cell cell : cf) {
            if (!cell.isLive(now)) continue;
            ++count;
        }
        return count;
    }

    @Override
    public boolean maySelectPrefix(CType type, Composite prefix) {
        for (CellName column : this.columns) {
            if (!prefix.isPrefixOf(type, column)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean shouldInclude(SSTableReader sstable) {
        return true;
    }

    @Override
    public boolean isFullyCoveredBy(ColumnFamily cf, long now) {
        CellName first = cf.iterator(ColumnSlice.ALL_COLUMNS_ARRAY).next().name();
        CellName last = cf.reverseIterator(ColumnSlice.ALL_COLUMNS_ARRAY).next().name();
        return cf.getComparator().compare(first, this.columns.first()) <= 0 && cf.getComparator().compare(this.columns.last(), last) <= 0;
    }

    @Override
    public boolean isHeadFilter() {
        return false;
    }

    @Override
    public boolean countCQL3Rows(CellNameType comparator) {
        return this.countCQL3Rows;
    }

    public boolean countCQL3Rows() {
        return this.countCQL3Rows(null);
    }

    @Override
    public ColumnCounter columnCounter(CellNameType comparator, long now) {
        return this.countCQL3Rows ? new ColumnCounter.GroupByPrefix(now, null, 0) : new ColumnCounter(now);
    }

    @Override
    public Iterator<RangeTombstone> getRangeTombstoneIterator(final ColumnFamily source) {
        if (!source.deletionInfo().hasRanges()) {
            return Iterators.emptyIterator();
        }
        return new AbstractIterator<RangeTombstone>(){
            private final Iterator<CellName> names;
            private RangeTombstone lastFindRange;
            {
                this.names = NamesQueryFilter.this.columns.iterator();
            }

            @Override
            protected RangeTombstone computeNext() {
                while (this.names.hasNext()) {
                    CellName next = this.names.next();
                    if (this.lastFindRange != null && this.lastFindRange.includes(source.getComparator(), next)) {
                        return this.lastFindRange;
                    }
                    this.lastFindRange = source.deletionInfo().rangeCovering(next);
                    if (this.lastFindRange == null) continue;
                    return this.lastFindRange;
                }
                return (RangeTombstone)this.endOfData();
            }
        };
    }

    public static class Serializer
    implements IVersionedSerializer<NamesQueryFilter> {
        private CellNameType type;

        public Serializer(CellNameType type) {
            this.type = type;
        }

        @Override
        public void serialize(NamesQueryFilter f, DataOutputPlus out, int version) throws IOException {
            out.writeInt(f.columns.size());
            ISerializer<CellName> serializer = this.type.cellSerializer();
            for (CellName cName : f.columns) {
                serializer.serialize(cName, out);
            }
            out.writeBoolean(f.countCQL3Rows);
        }

        @Override
        public NamesQueryFilter deserialize(DataInput in, int version) throws IOException {
            int size = in.readInt();
            TreeSet<Composite> columns = new TreeSet<Composite>(this.type);
            ISerializer<CellName> serializer = this.type.cellSerializer();
            for (int i = 0; i < size; ++i) {
                columns.add(serializer.deserialize(in));
            }
            boolean countCQL3Rows = in.readBoolean();
            return new NamesQueryFilter(columns, countCQL3Rows);
        }

        @Override
        public long serializedSize(NamesQueryFilter f, int version) {
            TypeSizes sizes = TypeSizes.NATIVE;
            int size = sizes.sizeof(f.columns.size());
            ISerializer<CellName> serializer = this.type.cellSerializer();
            for (CellName cName : f.columns) {
                size = (int)((long)size + serializer.serializedSize(cName, sizes));
            }
            return size += sizes.sizeof(f.countCQL3Rows);
        }
    }

    private static class ByNameColumnIterator
    extends AbstractIterator<OnDiskAtom>
    implements OnDiskAtomIterator {
        private final ColumnFamily cf;
        private final DecoratedKey key;
        private final Iterator<CellName> iter;

        public ByNameColumnIterator(Iterator<CellName> iter, DecoratedKey key, ColumnFamily cf) {
            this.iter = iter;
            this.cf = cf;
            this.key = key;
        }

        @Override
        protected OnDiskAtom computeNext() {
            while (this.iter.hasNext()) {
                CellName current = this.iter.next();
                Cell cell = this.cf.getColumn(current);
                if (cell == null) continue;
                return cell;
            }
            return (OnDiskAtom)this.endOfData();
        }

        @Override
        public ColumnFamily getColumnFamily() {
            return this.cf;
        }

        @Override
        public DecoratedKey getKey() {
            return this.key;
        }

        @Override
        public void close() throws IOException {
        }
    }
}

