/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.hadoop;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.cassandra.db.marshal.BytesType;
import org.apache.cassandra.hadoop.AbstractBulkRecordWriter;
import org.apache.cassandra.hadoop.ConfigHelper;
import org.apache.cassandra.hadoop.HadoopCompat;
import org.apache.cassandra.io.sstable.SSTableLoader;
import org.apache.cassandra.io.sstable.SSTableSimpleUnsortedWriter;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.util.Progressable;
import org.cassandraunit.shaded.org.apache.cassandra.thrift.Column;
import org.cassandraunit.shaded.org.apache.cassandra.thrift.CounterColumn;
import org.cassandraunit.shaded.org.apache.cassandra.thrift.Mutation;

public final class BulkRecordWriter
extends AbstractBulkRecordWriter<ByteBuffer, List<Mutation>> {
    private File outputDir;
    private CFType cfType;
    private ColType colType;

    BulkRecordWriter(TaskAttemptContext context) {
        super(context);
    }

    BulkRecordWriter(Configuration conf, Progressable progress) {
        super(conf, progress);
    }

    BulkRecordWriter(Configuration conf) {
        super(conf);
    }

    private void setTypes(Mutation mutation) {
        if (this.cfType == null) {
            this.cfType = mutation.getColumn_or_supercolumn().isSetSuper_column() || mutation.getColumn_or_supercolumn().isSetCounter_super_column() ? CFType.SUPER : CFType.NORMAL;
            this.colType = mutation.getColumn_or_supercolumn().isSetCounter_column() || mutation.getColumn_or_supercolumn().isSetCounter_super_column() ? ColType.COUNTER : ColType.NORMAL;
        }
    }

    private void prepareWriter() throws IOException {
        if (this.outputDir == null) {
            String keyspace = ConfigHelper.getOutputKeyspace(this.conf);
            this.outputDir = new File(this.getOutputLocation() + File.separator + keyspace + File.separator + ConfigHelper.getOutputColumnFamily(this.conf));
            this.outputDir.mkdirs();
        }
        if (this.writer == null) {
            BytesType subcomparator = null;
            if (this.cfType == CFType.SUPER) {
                subcomparator = BytesType.instance;
            }
            this.writer = new SSTableSimpleUnsortedWriter(this.outputDir, ConfigHelper.getOutputPartitioner(this.conf), ConfigHelper.getOutputKeyspace(this.conf), ConfigHelper.getOutputColumnFamily(this.conf), BytesType.instance, subcomparator, Integer.parseInt(this.conf.get("mapreduce.output.bulkoutputformat.buffersize", "64")), ConfigHelper.getOutputCompressionParamaters(this.conf));
            this.loader = new SSTableLoader(this.outputDir, new AbstractBulkRecordWriter.ExternalClient(this.conf), new AbstractBulkRecordWriter.NullOutputHandler());
        }
    }

    public void write(ByteBuffer keybuff, List<Mutation> value) throws IOException {
        this.setTypes(value.get(0));
        this.prepareWriter();
        SSTableSimpleUnsortedWriter ssWriter = (SSTableSimpleUnsortedWriter)this.writer;
        ssWriter.newRow(keybuff);
        for (Mutation mut : value) {
            if (this.cfType == CFType.SUPER) {
                ssWriter.newSuperColumn(mut.getColumn_or_supercolumn().getSuper_column().name);
                if (this.colType == ColType.COUNTER) {
                    for (CounterColumn counterColumn : mut.getColumn_or_supercolumn().getCounter_super_column().columns) {
                        ssWriter.addCounterColumn(counterColumn.name, counterColumn.value);
                    }
                } else {
                    for (Column column : mut.getColumn_or_supercolumn().getSuper_column().columns) {
                        if (column.ttl == 0) {
                            ssWriter.addColumn(column.name, column.value, column.timestamp);
                            continue;
                        }
                        ssWriter.addExpiringColumn(column.name, column.value, column.timestamp, column.ttl, System.currentTimeMillis() + (long)column.ttl * 1000L);
                    }
                }
            } else if (this.colType == ColType.COUNTER) {
                ssWriter.addCounterColumn(mut.getColumn_or_supercolumn().counter_column.name, mut.getColumn_or_supercolumn().counter_column.value);
            } else if (mut.getColumn_or_supercolumn().column.ttl == 0) {
                ssWriter.addColumn(mut.getColumn_or_supercolumn().column.name, mut.getColumn_or_supercolumn().column.value, mut.getColumn_or_supercolumn().column.timestamp);
            } else {
                ssWriter.addExpiringColumn(mut.getColumn_or_supercolumn().column.name, mut.getColumn_or_supercolumn().column.value, mut.getColumn_or_supercolumn().column.timestamp, mut.getColumn_or_supercolumn().column.ttl, System.currentTimeMillis() + (long)mut.getColumn_or_supercolumn().column.ttl * 1000L);
            }
            if (null != this.progress) {
                this.progress.progress();
            }
            if (null == this.context) continue;
            HadoopCompat.progress(this.context);
        }
    }

    private static enum ColType {
        NORMAL,
        COUNTER;

    }

    private static enum CFType {
        NORMAL,
        SUPER;

    }
}

