/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.util;

import org.apache.cassandra.io.compress.CompressedRandomAccessReader;
import org.apache.cassandra.io.compress.CompressedSequentialWriter;
import org.apache.cassandra.io.compress.CompressedThrottledReader;
import org.apache.cassandra.io.compress.CompressionMetadata;
import org.apache.cassandra.io.util.CompressedSegmentedFile;
import org.apache.cassandra.io.util.ICompressedFile;
import org.apache.cassandra.io.util.PoolingSegmentedFile;
import org.apache.cassandra.io.util.RandomAccessReader;
import org.apache.cassandra.io.util.SegmentedFile;
import org.cassandraunit.shaded.com.google.common.util.concurrent.RateLimiter;

public class CompressedPoolingSegmentedFile
extends PoolingSegmentedFile
implements ICompressedFile {
    public final CompressionMetadata metadata;

    public CompressedPoolingSegmentedFile(String path, CompressionMetadata metadata) {
        super(new Cleanup(path, metadata), path, metadata.dataLength, metadata.compressedFileLength);
        this.metadata = metadata;
    }

    private CompressedPoolingSegmentedFile(CompressedPoolingSegmentedFile copy) {
        super(copy);
        this.metadata = copy.metadata;
    }

    @Override
    public void dropPageCache(long before) {
        if (before >= this.metadata.dataLength) {
            super.dropPageCache(0L);
        }
        super.dropPageCache(this.metadata.chunkFor((long)before).offset);
    }

    @Override
    public RandomAccessReader createReader() {
        return CompressedRandomAccessReader.open(this.path, this.metadata, null);
    }

    @Override
    public RandomAccessReader createThrottledReader(RateLimiter limiter) {
        return CompressedThrottledReader.open(this.path, this.metadata, limiter);
    }

    @Override
    protected RandomAccessReader createPooledReader() {
        return CompressedRandomAccessReader.open(this.path, this.metadata, this);
    }

    @Override
    public CompressionMetadata getMetadata() {
        return this.metadata;
    }

    @Override
    public CompressedPoolingSegmentedFile sharedCopy() {
        return new CompressedPoolingSegmentedFile(this);
    }

    public static class Builder
    extends CompressedSegmentedFile.Builder {
        public Builder(CompressedSequentialWriter writer) {
            super(writer);
        }

        @Override
        public void addPotentialBoundary(long boundary) {
        }

        @Override
        public SegmentedFile complete(String path, long overrideLength, boolean isFinal) {
            return new CompressedPoolingSegmentedFile(path, this.metadata(path, overrideLength, isFinal));
        }
    }

    protected static final class Cleanup
    extends PoolingSegmentedFile.Cleanup {
        final CompressionMetadata metadata;

        protected Cleanup(String path, CompressionMetadata metadata) {
            super(path);
            this.metadata = metadata;
        }

        @Override
        public void tidy() throws Exception {
            super.tidy();
            this.metadata.close();
        }
    }
}

