/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.util;

import org.apache.cassandra.io.compress.CompressedRandomAccessReader;
import org.apache.cassandra.io.compress.CompressedSequentialWriter;
import org.apache.cassandra.io.compress.CompressedThrottledReader;
import org.apache.cassandra.io.compress.CompressionMetadata;
import org.apache.cassandra.io.util.ICompressedFile;
import org.apache.cassandra.io.util.RandomAccessReader;
import org.apache.cassandra.io.util.SegmentedFile;
import org.cassandraunit.shaded.com.google.common.util.concurrent.RateLimiter;

public class CompressedSegmentedFile
extends SegmentedFile
implements ICompressedFile {
    public final CompressionMetadata metadata;

    public CompressedSegmentedFile(String path, CompressionMetadata metadata) {
        super(new Cleanup(path, metadata), path, metadata.dataLength, metadata.compressedFileLength);
        this.metadata = metadata;
    }

    private CompressedSegmentedFile(CompressedSegmentedFile copy) {
        super(copy);
        this.metadata = copy.metadata;
    }

    @Override
    public CompressedSegmentedFile sharedCopy() {
        return new CompressedSegmentedFile(this);
    }

    @Override
    public void dropPageCache(long before) {
        if (before >= this.metadata.dataLength) {
            super.dropPageCache(0L);
        }
        super.dropPageCache(this.metadata.chunkFor((long)before).offset);
    }

    @Override
    public RandomAccessReader createReader() {
        return CompressedRandomAccessReader.open(this.path, this.metadata);
    }

    @Override
    public RandomAccessReader createThrottledReader(RateLimiter limiter) {
        return CompressedThrottledReader.open(this.path, this.metadata, limiter);
    }

    @Override
    public CompressionMetadata getMetadata() {
        return this.metadata;
    }

    public static class Builder
    extends SegmentedFile.Builder {
        protected final CompressedSequentialWriter writer;

        public Builder(CompressedSequentialWriter writer) {
            this.writer = writer;
        }

        @Override
        public void addPotentialBoundary(long boundary) {
        }

        protected CompressionMetadata metadata(String path, long overrideLength, boolean isFinal) {
            if (this.writer == null) {
                return CompressionMetadata.create(path);
            }
            return this.writer.open(overrideLength, isFinal);
        }

        @Override
        public SegmentedFile complete(String path, long overrideLength, boolean isFinal) {
            assert (!isFinal || overrideLength <= 0L);
            return new CompressedSegmentedFile(path, this.metadata(path, overrideLength, isFinal));
        }
    }

    private static final class Cleanup
    extends SegmentedFile.Cleanup {
        final CompressionMetadata metadata;

        protected Cleanup(String path, CompressionMetadata metadata) {
            super(path);
            this.metadata = metadata;
        }

        @Override
        public void tidy() throws Exception {
            this.metadata.close();
        }
    }
}

