/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.util;

import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.DataOutput;
import java.io.File;
import java.io.IOError;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.zip.Adler32;
import java.util.zip.Checksum;
import org.apache.cassandra.io.FSWriteError;
import org.apache.cassandra.io.sstable.Component;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.io.util.RandomAccessReader;
import org.apache.cassandra.utils.PureJavaCrc32;
import org.cassandraunit.shaded.com.google.common.base.Charsets;

public class DataIntegrityMetadata {
    public static ChecksumValidator checksumValidator(Descriptor desc) throws IOException {
        return new ChecksumValidator(desc);
    }

    public static class ChecksumWriter {
        private final Checksum incrementalChecksum = new Adler32();
        private final DataOutput incrementalOut;
        private final Checksum fullChecksum = new Adler32();

        public ChecksumWriter(DataOutput incrementalOut) {
            this.incrementalOut = incrementalOut;
        }

        public void writeChunkSize(int length) {
            try {
                this.incrementalOut.writeInt(length);
            }
            catch (IOException e) {
                throw new IOError(e);
            }
        }

        public void append(byte[] buffer, int start, int end, boolean checksumIncrementalResult) {
            try {
                this.incrementalChecksum.update(buffer, start, end);
                int incrementalChecksumValue = (int)this.incrementalChecksum.getValue();
                this.incrementalOut.writeInt(incrementalChecksumValue);
                this.incrementalChecksum.reset();
                this.fullChecksum.update(buffer, start, end);
                if (checksumIncrementalResult) {
                    ByteBuffer byteBuffer = ByteBuffer.allocate(4);
                    byteBuffer.putInt(incrementalChecksumValue);
                    this.fullChecksum.update(byteBuffer.array(), 0, byteBuffer.array().length);
                }
            }
            catch (IOException e) {
                throw new IOError(e);
            }
        }

        public void writeFullChecksum(Descriptor descriptor) {
            File outFile = new File(descriptor.filenameFor(Component.DIGEST));
            BufferedWriter out = null;
            try {
                out = Files.newBufferedWriter(outFile.toPath(), Charsets.UTF_8, new OpenOption[0]);
                out.write(String.valueOf(this.fullChecksum.getValue()));
            }
            catch (IOException e) {
                try {
                    throw new FSWriteError((Throwable)e, outFile);
                }
                catch (Throwable throwable) {
                    FileUtils.closeQuietly(out);
                    throw throwable;
                }
            }
            FileUtils.closeQuietly(out);
        }
    }

    public static class ChecksumValidator
    implements Closeable {
        private final Checksum checksum;
        private final RandomAccessReader reader;
        private final Descriptor descriptor;
        public final int chunkSize;

        public ChecksumValidator(Descriptor descriptor) throws IOException {
            this.descriptor = descriptor;
            this.checksum = descriptor.version.hasAllAdlerChecksums ? new Adler32() : new PureJavaCrc32();
            this.reader = RandomAccessReader.open(new File(descriptor.filenameFor(Component.CRC)));
            this.chunkSize = this.reader.readInt();
        }

        public void seek(long offset) {
            long start = this.chunkStart(offset);
            this.reader.seek(start / (long)this.chunkSize * 4L + 4L);
        }

        public long chunkStart(long offset) {
            long startChunk = offset / (long)this.chunkSize;
            return startChunk * (long)this.chunkSize;
        }

        public void validate(byte[] bytes, int start, int end) throws IOException {
            this.checksum.update(bytes, start, end);
            int current = (int)this.checksum.getValue();
            this.checksum.reset();
            int actual = this.reader.readInt();
            if (current != actual) {
                throw new IOException("Corrupted SSTable : " + this.descriptor.filenameFor(Component.DATA));
            }
        }

        @Override
        public void close() {
            this.reader.close();
        }
    }
}

