/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.util;

import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.apache.cassandra.io.FSReadError;
import org.apache.cassandra.io.util.FileDataInput;
import org.apache.cassandra.io.util.FileMark;
import org.apache.cassandra.io.util.PoolingSegmentedFile;
import org.apache.cassandra.io.util.SequentialWriter;
import org.cassandraunit.shaded.com.google.common.annotations.VisibleForTesting;

public class RandomAccessReader
extends RandomAccessFile
implements FileDataInput {
    public static final long CACHE_FLUSH_INTERVAL_IN_BYTES = (long)Math.pow(2.0, 27.0);
    public static final int DEFAULT_BUFFER_SIZE = 65536;
    private final String filePath;
    protected byte[] buffer;
    protected long bufferOffset;
    protected long current = 0L;
    protected long markedPointer;
    protected int validBufferBytes = 0;
    protected final FileChannel channel;
    private final long fileLength;
    protected final PoolingSegmentedFile owner;

    protected RandomAccessReader(File file, int bufferSize, PoolingSegmentedFile owner) throws FileNotFoundException {
        this(file, bufferSize, -1L, owner);
    }

    protected RandomAccessReader(File file, int bufferSize, long overrideLength, PoolingSegmentedFile owner) throws FileNotFoundException {
        super(file, "r");
        this.owner = owner;
        this.channel = super.getChannel();
        this.filePath = file.getAbsolutePath();
        if (bufferSize <= 0) {
            throw new IllegalArgumentException("bufferSize must be positive");
        }
        this.buffer = new byte[bufferSize];
        long fileLength = overrideLength;
        if (fileLength <= 0L) {
            try {
                fileLength = this.channel.size();
            }
            catch (IOException e) {
                throw new FSReadError((Throwable)e, this.filePath);
            }
        }
        this.fileLength = fileLength;
        this.validBufferBytes = -1;
    }

    public static RandomAccessReader open(File file, long overrideSize, PoolingSegmentedFile owner) {
        return RandomAccessReader.open(file, 65536, overrideSize, owner);
    }

    public static RandomAccessReader open(File file) {
        return RandomAccessReader.open(file, -1L);
    }

    public static RandomAccessReader open(File file, long overrideSize) {
        return RandomAccessReader.open(file, 65536, overrideSize, null);
    }

    @VisibleForTesting
    static RandomAccessReader open(File file, int bufferSize, PoolingSegmentedFile owner) {
        return RandomAccessReader.open(file, bufferSize, -1L, owner);
    }

    private static RandomAccessReader open(File file, int bufferSize, long overrideSize, PoolingSegmentedFile owner) {
        try {
            return new RandomAccessReader(file, bufferSize, overrideSize, owner);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    @VisibleForTesting
    static RandomAccessReader open(SequentialWriter writer) {
        return RandomAccessReader.open(new File(writer.getPath()), 65536, null);
    }

    protected void reBuffer() {
        this.resetBuffer();
        try {
            int read = this.buffer.length;
            if (this.bufferOffset + (long)read > this.fileLength) {
                if (this.bufferOffset >= this.fileLength) {
                    return;
                }
                read = (int)(this.fileLength - this.bufferOffset);
            }
            this.channel.position(this.bufferOffset);
            int offset = 0;
            while (read > 0) {
                int n = super.read(this.buffer, offset, read);
                if (n < 0) {
                    throw new IllegalStateException();
                }
                read -= n;
                offset += n;
            }
            this.validBufferBytes = offset;
        }
        catch (IOException e) {
            throw new FSReadError((Throwable)e, this.filePath);
        }
    }

    @Override
    public long getFilePointer() {
        return this.current;
    }

    @Override
    public String getPath() {
        return this.filePath;
    }

    public int getTotalBufferSize() {
        byte[] ref = this.buffer;
        return ref != null ? ref.length : 0;
    }

    public void reset() {
        this.seek(this.markedPointer);
    }

    public long bytesPastMark() {
        long bytes = this.current - this.markedPointer;
        assert (bytes >= 0L);
        return bytes;
    }

    @Override
    public FileMark mark() {
        this.markedPointer = this.current;
        return new BufferedRandomAccessFileMark(this.markedPointer);
    }

    @Override
    public void reset(FileMark mark) {
        assert (mark instanceof BufferedRandomAccessFileMark);
        this.seek(((BufferedRandomAccessFileMark)mark).pointer);
    }

    @Override
    public long bytesPastMark(FileMark mark) {
        assert (mark instanceof BufferedRandomAccessFileMark);
        long bytes = this.current - ((BufferedRandomAccessFileMark)mark).pointer;
        assert (bytes >= 0L);
        return bytes;
    }

    @Override
    public boolean isEOF() {
        return this.getFilePointer() == this.length();
    }

    @Override
    public long bytesRemaining() {
        return this.length() - this.getFilePointer();
    }

    protected int bufferCursor() {
        return (int)(this.current - this.bufferOffset);
    }

    protected void resetBuffer() {
        this.bufferOffset = this.current;
        this.validBufferBytes = 0;
    }

    @Override
    public void close() {
        if (this.owner == null || this.buffer == null) {
            this.deallocate();
        } else {
            this.owner.recycle(this);
        }
    }

    public void deallocate() {
        this.buffer = null;
        try {
            super.close();
        }
        catch (IOException e) {
            throw new FSReadError((Throwable)e, this.filePath);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + "filePath='" + this.filePath + "')";
    }

    @Override
    public void seek(long newPosition) {
        if (newPosition < 0L) {
            throw new IllegalArgumentException("new position should not be negative");
        }
        if (newPosition > this.length()) {
            throw new IllegalArgumentException(String.format("unable to seek to position %d in %s (%d bytes) in read-only mode", newPosition, this.getPath(), this.length()));
        }
        this.current = newPosition;
        if (newPosition > this.bufferOffset + (long)this.validBufferBytes || newPosition < this.bufferOffset) {
            this.reBuffer();
        }
    }

    @Override
    public int read() {
        if (this.buffer == null) {
            throw new AssertionError((Object)"Attempted to read from closed RAR");
        }
        if (this.isEOF()) {
            return -1;
        }
        if (this.current >= this.bufferOffset + (long)this.buffer.length || this.validBufferBytes == -1) {
            this.reBuffer();
        }
        assert (this.current >= this.bufferOffset && this.current < this.bufferOffset + (long)this.validBufferBytes);
        return this.buffer[(int)(this.current++ - this.bufferOffset)] & 0xFF;
    }

    @Override
    public int read(byte[] buffer) {
        return this.read(buffer, 0, buffer.length);
    }

    @Override
    public int read(byte[] buff, int offset, int length) {
        if (this.buffer == null) {
            throw new AssertionError((Object)"Attempted to read from closed RAR");
        }
        if (length == 0) {
            return 0;
        }
        if (this.isEOF()) {
            return -1;
        }
        if (this.current >= this.bufferOffset + (long)this.buffer.length || this.validBufferBytes == -1) {
            this.reBuffer();
        }
        assert (this.current >= this.bufferOffset && this.current < this.bufferOffset + (long)this.validBufferBytes) : String.format("File (%s), current offset %d, buffer offset %d, buffer limit %d", this.getPath(), this.current, this.bufferOffset, this.validBufferBytes);
        int toCopy = Math.min(length, this.validBufferBytes - this.bufferCursor());
        System.arraycopy(this.buffer, this.bufferCursor(), buff, offset, toCopy);
        this.current += (long)toCopy;
        return toCopy;
    }

    @Override
    public ByteBuffer readBytes(int length) throws EOFException {
        assert (length >= 0) : "buffer length should not be negative: " + length;
        byte[] buff = new byte[length];
        try {
            this.readFully(buff);
        }
        catch (EOFException e) {
            throw e;
        }
        catch (IOException e) {
            throw new FSReadError((Throwable)e, this.filePath);
        }
        return ByteBuffer.wrap(buff);
    }

    @Override
    public long length() {
        return this.fileLength;
    }

    public long getPosition() {
        return this.current;
    }

    @Override
    public void write(int value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void write(byte[] buffer) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void write(byte[] buffer, int offset, int length) {
        throw new UnsupportedOperationException();
    }

    protected static class BufferedRandomAccessFileMark
    implements FileMark {
        final long pointer;

        public BufferedRandomAccessFileMark(long pointer) {
            this.pointer = pointer;
        }
    }
}

