/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.util;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.nio.MappedByteBuffer;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.cassandra.config.Config;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.io.FSReadError;
import org.apache.cassandra.io.compress.CompressedSequentialWriter;
import org.apache.cassandra.io.util.BufferedPoolingSegmentedFile;
import org.apache.cassandra.io.util.CompressedPoolingSegmentedFile;
import org.apache.cassandra.io.util.FileDataInput;
import org.apache.cassandra.io.util.MmappedSegmentedFile;
import org.apache.cassandra.io.util.RandomAccessReader;
import org.apache.cassandra.io.util.ThrottledReader;
import org.apache.cassandra.utils.CLibrary;
import org.apache.cassandra.utils.Pair;
import org.apache.cassandra.utils.concurrent.RefCounted;
import org.apache.cassandra.utils.concurrent.SharedCloseableImpl;
import org.cassandraunit.shaded.com.google.common.util.concurrent.RateLimiter;

public abstract class SegmentedFile
extends SharedCloseableImpl {
    public final String path;
    public final long length;
    public final long onDiskLength;

    SegmentedFile(Cleanup cleanup, String path, long length) {
        this(cleanup, path, length, length);
    }

    protected SegmentedFile(Cleanup cleanup, String path, long length, long onDiskLength) {
        super(cleanup);
        this.path = new File(path).getAbsolutePath();
        this.length = length;
        this.onDiskLength = onDiskLength;
    }

    public SegmentedFile(SegmentedFile copy) {
        super(copy);
        this.path = copy.path;
        this.length = copy.length;
        this.onDiskLength = copy.onDiskLength;
    }

    @Override
    public abstract SegmentedFile sharedCopy();

    public RandomAccessReader createReader() {
        return RandomAccessReader.open(new File(this.path), this.length);
    }

    public RandomAccessReader createThrottledReader(RateLimiter limiter) {
        assert (limiter != null);
        return ThrottledReader.open(new File(this.path), this.length, limiter);
    }

    public FileDataInput getSegment(long position) {
        RandomAccessReader reader = this.createReader();
        reader.seek(position);
        return reader;
    }

    public void dropPageCache(long before) {
        CLibrary.trySkipCache(this.path, 0L, before);
    }

    public static Builder getBuilder(Config.DiskAccessMode mode) {
        return mode == Config.DiskAccessMode.mmap ? new MmappedSegmentedFile.Builder() : new BufferedPoolingSegmentedFile.Builder();
    }

    public static Builder getCompressedBuilder() {
        return SegmentedFile.getCompressedBuilder(null);
    }

    public static Builder getCompressedBuilder(CompressedSequentialWriter writer) {
        return new CompressedPoolingSegmentedFile.Builder(writer);
    }

    public Iterator<FileDataInput> iterator(long position) {
        return new SegmentIterator(position);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(path='" + this.path + "'" + ", length=" + this.length + ")";
    }

    final class SegmentIterator
    implements Iterator<FileDataInput> {
        private long nextpos;

        public SegmentIterator(long position) {
            this.nextpos = position;
        }

        @Override
        public boolean hasNext() {
            return this.nextpos < SegmentedFile.this.length;
        }

        @Override
        public FileDataInput next() {
            long position = this.nextpos;
            if (position >= SegmentedFile.this.length) {
                throw new NoSuchElementException();
            }
            FileDataInput segment = SegmentedFile.this.getSegment(this.nextpos);
            try {
                this.nextpos += segment.bytesRemaining();
            }
            catch (IOException e) {
                throw new FSReadError((Throwable)e, SegmentedFile.this.path);
            }
            return segment;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    static final class Segment
    extends Pair<Long, MappedByteBuffer>
    implements Comparable<Segment> {
        public Segment(long offset, MappedByteBuffer segment) {
            super(offset, segment);
        }

        @Override
        public final int compareTo(Segment that) {
            return (int)Math.signum((Long)this.left - (Long)that.left);
        }
    }

    public static abstract class Builder {
        public abstract void addPotentialBoundary(long var1);

        protected abstract SegmentedFile complete(String var1, long var2, boolean var4);

        public SegmentedFile complete(String path) {
            return this.complete(path, -1L, true);
        }

        public SegmentedFile complete(String path, boolean isFinal) {
            return this.complete(path, -1L, isFinal);
        }

        public SegmentedFile complete(String path, long overrideLength) {
            return this.complete(path, overrideLength, false);
        }

        public void serializeBounds(DataOutput out) throws IOException {
            out.writeUTF(DatabaseDescriptor.getDiskAccessMode().name());
        }

        public void deserializeBounds(DataInput in) throws IOException {
            if (!in.readUTF().equals(DatabaseDescriptor.getDiskAccessMode().name())) {
                throw new IOException("Cannot deserialize SSTable Summary component because the DiskAccessMode was changed!");
            }
        }
    }

    protected static abstract class Cleanup
    implements RefCounted.Tidy {
        final String path;

        protected Cleanup(String path) {
            this.path = path;
        }

        @Override
        public String name() {
            return this.path;
        }
    }
}

