/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.util;

import java.io.File;
import java.io.FileNotFoundException;
import org.apache.cassandra.io.util.RandomAccessReader;
import org.cassandraunit.shaded.com.google.common.util.concurrent.RateLimiter;

public class ThrottledReader
extends RandomAccessReader {
    private final RateLimiter limiter;

    protected ThrottledReader(File file, long overrideLength, RateLimiter limiter) throws FileNotFoundException {
        super(file, 65536, overrideLength, null);
        this.limiter = limiter;
    }

    @Override
    protected void reBuffer() {
        this.limiter.acquire(this.buffer.length);
        super.reBuffer();
    }

    public static ThrottledReader open(File file, long overrideLength, RateLimiter limiter) {
        try {
            return new ThrottledReader(file, overrideLength, limiter);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }
}

