/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.metrics;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.cassandra.cache.ICache;
import org.apache.cassandra.metrics.DefaultNameFactory;
import org.cassandraunit.shaded.com.yammer.metrics.Metrics;
import org.cassandraunit.shaded.com.yammer.metrics.core.Gauge;
import org.cassandraunit.shaded.com.yammer.metrics.core.Meter;
import org.cassandraunit.shaded.com.yammer.metrics.util.RatioGauge;

public class CacheMetrics {
    public final Gauge<Long> capacity;
    public final Meter hits;
    public final Meter requests;
    public final Gauge<Double> hitRate;
    public final Gauge<Long> size;
    public final Gauge<Integer> entries;
    private final AtomicLong lastRequests = new AtomicLong(0L);
    private final AtomicLong lastHits = new AtomicLong(0L);

    public CacheMetrics(String type, final ICache cache) {
        DefaultNameFactory factory = new DefaultNameFactory("Cache", type);
        this.capacity = Metrics.newGauge(factory.createMetricName("Capacity"), new Gauge<Long>(){

            @Override
            public Long value() {
                return cache.capacity();
            }
        });
        this.hits = Metrics.newMeter(factory.createMetricName("Hits"), "hits", TimeUnit.SECONDS);
        this.requests = Metrics.newMeter(factory.createMetricName("Requests"), "requests", TimeUnit.SECONDS);
        this.hitRate = Metrics.newGauge(factory.createMetricName("HitRate"), new RatioGauge(){

            @Override
            protected double getNumerator() {
                return CacheMetrics.this.hits.count();
            }

            @Override
            protected double getDenominator() {
                return CacheMetrics.this.requests.count();
            }
        });
        this.size = Metrics.newGauge(factory.createMetricName("Size"), new Gauge<Long>(){

            @Override
            public Long value() {
                return cache.weightedSize();
            }
        });
        this.entries = Metrics.newGauge(factory.createMetricName("Entries"), new Gauge<Integer>(){

            @Override
            public Integer value() {
                return cache.size();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public double getRecentHitRate() {
        long r = this.requests.count();
        long h = this.hits.count();
        try {
            double d = (double)(h - this.lastHits.get()) / (double)(r - this.lastRequests.get());
            return d;
        }
        finally {
            this.lastRequests.set(r);
            this.lastHits.set(h);
        }
    }
}

