/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.metrics;

import java.util.concurrent.TimeUnit;
import org.apache.cassandra.db.commitlog.AbstractCommitLogService;
import org.apache.cassandra.db.commitlog.CommitLogSegmentManager;
import org.apache.cassandra.metrics.DefaultNameFactory;
import org.apache.cassandra.metrics.MetricNameFactory;
import org.cassandraunit.shaded.com.yammer.metrics.Metrics;
import org.cassandraunit.shaded.com.yammer.metrics.core.Gauge;
import org.cassandraunit.shaded.com.yammer.metrics.core.Timer;

public class CommitLogMetrics {
    public static final MetricNameFactory factory = new DefaultNameFactory("CommitLog");
    public final Gauge<Long> completedTasks;
    public final Gauge<Long> pendingTasks;
    public final Gauge<Long> totalCommitLogSize;
    public final Timer waitingOnSegmentAllocation;
    public final Timer waitingOnCommit;

    public CommitLogMetrics(final AbstractCommitLogService service, final CommitLogSegmentManager allocator) {
        this.completedTasks = Metrics.newGauge(factory.createMetricName("CompletedTasks"), new Gauge<Long>(){

            @Override
            public Long value() {
                return service.getCompletedTasks();
            }
        });
        this.pendingTasks = Metrics.newGauge(factory.createMetricName("PendingTasks"), new Gauge<Long>(){

            @Override
            public Long value() {
                return service.getPendingTasks();
            }
        });
        this.totalCommitLogSize = Metrics.newGauge(factory.createMetricName("TotalCommitLogSize"), new Gauge<Long>(){

            @Override
            public Long value() {
                return allocator.bytesUsed();
            }
        });
        this.waitingOnSegmentAllocation = Metrics.newTimer(factory.createMetricName("WaitingOnSegmentAllocation"), TimeUnit.MICROSECONDS, TimeUnit.SECONDS);
        this.waitingOnCommit = Metrics.newTimer(factory.createMetricName("WaitingOnCommit"), TimeUnit.MICROSECONDS, TimeUnit.SECONDS);
    }
}

