/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.metrics;

import java.util.concurrent.TimeUnit;
import org.apache.cassandra.metrics.DefaultNameFactory;
import org.apache.cassandra.metrics.MetricNameFactory;
import org.apache.cassandra.service.FileCacheService;
import org.cassandraunit.shaded.com.yammer.metrics.Metrics;
import org.cassandraunit.shaded.com.yammer.metrics.core.Gauge;
import org.cassandraunit.shaded.com.yammer.metrics.core.Meter;
import org.cassandraunit.shaded.com.yammer.metrics.util.RatioGauge;

public class FileCacheMetrics {
    private static final MetricNameFactory factory = new DefaultNameFactory("FileCache");
    public final Meter hits = Metrics.newMeter(factory.createMetricName("Hits"), "hits", TimeUnit.SECONDS);
    public final Meter requests = Metrics.newMeter(factory.createMetricName("Requests"), "requests", TimeUnit.SECONDS);
    public final Gauge<Double> hitRate = Metrics.newGauge(factory.createMetricName("HitRate"), new RatioGauge(){

        @Override
        protected double getNumerator() {
            return FileCacheMetrics.this.hits.count();
        }

        @Override
        protected double getDenominator() {
            return FileCacheMetrics.this.requests.count();
        }
    });
    public final Gauge<Long> size = Metrics.newGauge(factory.createMetricName("Size"), new Gauge<Long>(){

        @Override
        public Long value() {
            return FileCacheService.instance.sizeInBytes();
        }
    });
}

