/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.metrics;

import java.util.Set;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.metrics.ColumnFamilyMetrics;
import org.apache.cassandra.metrics.LatencyMetrics;
import org.apache.cassandra.metrics.MetricNameFactory;
import org.cassandraunit.shaded.com.google.common.collect.Lists;
import org.cassandraunit.shaded.com.google.common.collect.Sets;
import org.cassandraunit.shaded.com.yammer.metrics.Metrics;
import org.cassandraunit.shaded.com.yammer.metrics.core.Gauge;
import org.cassandraunit.shaded.com.yammer.metrics.core.Histogram;
import org.cassandraunit.shaded.com.yammer.metrics.core.MetricName;

public class KeyspaceMetrics {
    public final Gauge<Long> memtableLiveDataSize;
    public final Gauge<Long> memtableOnHeapDataSize;
    public final Gauge<Long> memtableOffHeapDataSize;
    public final Gauge<Long> allMemtablesLiveDataSize;
    public final Gauge<Long> allMemtablesOnHeapDataSize;
    public final Gauge<Long> allMemtablesOffHeapDataSize;
    public final Gauge<Long> memtableColumnsCount;
    public final Gauge<Long> memtableSwitchCount;
    public final Gauge<Long> pendingFlushes;
    public final Gauge<Long> pendingCompactions;
    public final Gauge<Long> liveDiskSpaceUsed;
    public final Gauge<Long> totalDiskSpaceUsed;
    public final Gauge<Long> bloomFilterDiskSpaceUsed;
    public final Gauge<Long> bloomFilterOffHeapMemoryUsed;
    public final Gauge<Long> indexSummaryOffHeapMemoryUsed;
    public final Gauge<Long> compressionMetadataOffHeapMemoryUsed;
    public final LatencyMetrics readLatency;
    public final LatencyMetrics rangeLatency;
    public final LatencyMetrics writeLatency;
    public final Histogram sstablesPerReadHistogram;
    public final Histogram tombstoneScannedHistogram;
    public final Histogram liveScannedHistogram;
    public final Histogram colUpdateTimeDeltaHistogram;
    public final LatencyMetrics casPrepare;
    public final LatencyMetrics casPropose;
    public final LatencyMetrics casCommit;
    public final MetricNameFactory factory;
    private Keyspace keyspace;
    private Set<String> allMetrics = Sets.newHashSet();

    public KeyspaceMetrics(Keyspace ks) {
        this.factory = new KeyspaceMetricNameFactory(ks);
        this.keyspace = ks;
        this.memtableColumnsCount = this.createKeyspaceGauge("MemtableColumnsCount", new MetricValue(){

            @Override
            public Long getValue(ColumnFamilyMetrics metric) {
                return metric.memtableColumnsCount.value();
            }
        });
        this.memtableLiveDataSize = this.createKeyspaceGauge("MemtableLiveDataSize", new MetricValue(){

            @Override
            public Long getValue(ColumnFamilyMetrics metric) {
                return metric.memtableLiveDataSize.value();
            }
        });
        this.memtableOnHeapDataSize = this.createKeyspaceGauge("MemtableOnHeapDataSize", new MetricValue(){

            @Override
            public Long getValue(ColumnFamilyMetrics metric) {
                return metric.memtableOnHeapSize.value();
            }
        });
        this.memtableOffHeapDataSize = this.createKeyspaceGauge("MemtableOffHeapDataSize", new MetricValue(){

            @Override
            public Long getValue(ColumnFamilyMetrics metric) {
                return metric.memtableOffHeapSize.value();
            }
        });
        this.allMemtablesLiveDataSize = this.createKeyspaceGauge("AllMemtablesLiveDataSize", new MetricValue(){

            @Override
            public Long getValue(ColumnFamilyMetrics metric) {
                return metric.allMemtablesLiveDataSize.value();
            }
        });
        this.allMemtablesOnHeapDataSize = this.createKeyspaceGauge("AllMemtablesOnHeapDataSize", new MetricValue(){

            @Override
            public Long getValue(ColumnFamilyMetrics metric) {
                return metric.allMemtablesOnHeapSize.value();
            }
        });
        this.allMemtablesOffHeapDataSize = this.createKeyspaceGauge("AllMemtablesOffHeapDataSize", new MetricValue(){

            @Override
            public Long getValue(ColumnFamilyMetrics metric) {
                return metric.allMemtablesOffHeapSize.value();
            }
        });
        this.memtableSwitchCount = this.createKeyspaceGauge("MemtableSwitchCount", new MetricValue(){

            @Override
            public Long getValue(ColumnFamilyMetrics metric) {
                return metric.memtableSwitchCount.count();
            }
        });
        this.pendingCompactions = this.createKeyspaceGauge("PendingCompactions", new MetricValue(){

            @Override
            public Long getValue(ColumnFamilyMetrics metric) {
                return (long)metric.pendingCompactions.value();
            }
        });
        this.pendingFlushes = this.createKeyspaceGauge("PendingFlushes", new MetricValue(){

            @Override
            public Long getValue(ColumnFamilyMetrics metric) {
                return metric.pendingFlushes.count();
            }
        });
        this.liveDiskSpaceUsed = this.createKeyspaceGauge("LiveDiskSpaceUsed", new MetricValue(){

            @Override
            public Long getValue(ColumnFamilyMetrics metric) {
                return metric.liveDiskSpaceUsed.count();
            }
        });
        this.totalDiskSpaceUsed = this.createKeyspaceGauge("TotalDiskSpaceUsed", new MetricValue(){

            @Override
            public Long getValue(ColumnFamilyMetrics metric) {
                return metric.totalDiskSpaceUsed.count();
            }
        });
        this.bloomFilterDiskSpaceUsed = this.createKeyspaceGauge("BloomFilterDiskSpaceUsed", new MetricValue(){

            @Override
            public Long getValue(ColumnFamilyMetrics metric) {
                return metric.bloomFilterDiskSpaceUsed.value();
            }
        });
        this.bloomFilterOffHeapMemoryUsed = this.createKeyspaceGauge("BloomFilterOffHeapMemoryUsed", new MetricValue(){

            @Override
            public Long getValue(ColumnFamilyMetrics metric) {
                return metric.bloomFilterOffHeapMemoryUsed.value();
            }
        });
        this.indexSummaryOffHeapMemoryUsed = this.createKeyspaceGauge("IndexSummaryOffHeapMemoryUsed", new MetricValue(){

            @Override
            public Long getValue(ColumnFamilyMetrics metric) {
                return metric.indexSummaryOffHeapMemoryUsed.value();
            }
        });
        this.compressionMetadataOffHeapMemoryUsed = this.createKeyspaceGauge("CompressionMetadataOffHeapMemoryUsed", new MetricValue(){

            @Override
            public Long getValue(ColumnFamilyMetrics metric) {
                return metric.compressionMetadataOffHeapMemoryUsed.value();
            }
        });
        this.readLatency = new LatencyMetrics(this.factory, "Read");
        this.writeLatency = new LatencyMetrics(this.factory, "Write");
        this.rangeLatency = new LatencyMetrics(this.factory, "Range");
        this.sstablesPerReadHistogram = Metrics.newHistogram(this.factory.createMetricName("SSTablesPerReadHistogram"), true);
        this.tombstoneScannedHistogram = Metrics.newHistogram(this.factory.createMetricName("TombstoneScannedHistogram"), true);
        this.liveScannedHistogram = Metrics.newHistogram(this.factory.createMetricName("LiveScannedHistogram"), true);
        this.colUpdateTimeDeltaHistogram = Metrics.newHistogram(this.factory.createMetricName("ColUpdateTimeDeltaHistogram"), true);
        this.allMetrics.addAll(Lists.newArrayList("SSTablesPerReadHistogram", "TombstoneScannedHistogram", "LiveScannedHistogram"));
        this.casPrepare = new LatencyMetrics(this.factory, "CasPrepare");
        this.casPropose = new LatencyMetrics(this.factory, "CasPropose");
        this.casCommit = new LatencyMetrics(this.factory, "CasCommit");
    }

    public void release() {
        for (String name : this.allMetrics) {
            Metrics.defaultRegistry().removeMetric(this.factory.createMetricName(name));
        }
        this.readLatency.release();
        this.writeLatency.release();
        this.rangeLatency.release();
    }

    private <T extends Number> Gauge<Long> createKeyspaceGauge(String name, final MetricValue extractor) {
        this.allMetrics.add(name);
        return Metrics.newGauge(this.factory.createMetricName(name), new Gauge<Long>(){

            @Override
            public Long value() {
                long sum = 0L;
                for (ColumnFamilyStore cf : KeyspaceMetrics.this.keyspace.getColumnFamilyStores()) {
                    sum += extractor.getValue(cf.metric).longValue();
                }
                return sum;
            }
        });
    }

    class KeyspaceMetricNameFactory
    implements MetricNameFactory {
        private final String keyspaceName;

        KeyspaceMetricNameFactory(Keyspace ks) {
            this.keyspaceName = ks.getName();
        }

        @Override
        public MetricName createMetricName(String metricName) {
            String groupName = ColumnFamilyMetrics.class.getPackage().getName();
            StringBuilder mbeanName = new StringBuilder();
            mbeanName.append(groupName).append(":");
            mbeanName.append("type=Keyspace");
            mbeanName.append(",keyspace=").append(this.keyspaceName);
            mbeanName.append(",name=").append(metricName);
            return new MetricName(groupName, "keyspace", metricName, this.keyspaceName, mbeanName.toString());
        }
    }

    private static interface MetricValue {
        public Long getValue(ColumnFamilyMetrics var1);
    }
}

