/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.metrics;

import org.apache.cassandra.concurrent.SEPExecutor;
import org.apache.cassandra.metrics.MetricNameFactory;
import org.apache.cassandra.metrics.ThreadPoolMetricNameFactory;
import org.cassandraunit.shaded.com.yammer.metrics.Metrics;
import org.cassandraunit.shaded.com.yammer.metrics.core.Gauge;

public class SEPMetrics {
    public final Gauge<Integer> activeTasks;
    public final Gauge<Integer> totalBlocked;
    public final Gauge<Long> currentBlocked;
    public final Gauge<Long> completedTasks;
    public final Gauge<Long> pendingTasks;
    public final Gauge<Integer> maxPoolSize;
    private MetricNameFactory factory;

    public SEPMetrics(final SEPExecutor executor, String path, String poolName) {
        this.factory = new ThreadPoolMetricNameFactory("ThreadPools", path, poolName);
        this.activeTasks = Metrics.newGauge(this.factory.createMetricName("ActiveTasks"), new Gauge<Integer>(){

            @Override
            public Integer value() {
                return executor.getActiveCount();
            }
        });
        this.pendingTasks = Metrics.newGauge(this.factory.createMetricName("PendingTasks"), new Gauge<Long>(){

            @Override
            public Long value() {
                return executor.getPendingTasks();
            }
        });
        this.totalBlocked = Metrics.newGauge(this.factory.createMetricName("TotalBlockedTasks"), new Gauge<Integer>(){

            @Override
            public Integer value() {
                return executor.getTotalBlockedTasks();
            }
        });
        this.currentBlocked = Metrics.newGauge(this.factory.createMetricName("CurrentlyBlockedTasks"), new Gauge<Long>(){

            @Override
            public Long value() {
                return executor.getCurrentlyBlockedTasks();
            }
        });
        this.completedTasks = Metrics.newGauge(this.factory.createMetricName("CompletedTasks"), new Gauge<Long>(){

            @Override
            public Long value() {
                return executor.getCompletedTasks();
            }
        });
        this.maxPoolSize = Metrics.newGauge(this.factory.createMetricName("MaxPoolSize"), new Gauge<Integer>(){

            @Override
            public Integer value() {
                return executor.maxWorkers;
            }
        });
    }

    public void release() {
        Metrics.defaultRegistry().removeMetric(this.factory.createMetricName("ActiveTasks"));
        Metrics.defaultRegistry().removeMetric(this.factory.createMetricName("PendingTasks"));
        Metrics.defaultRegistry().removeMetric(this.factory.createMetricName("CompletedTasks"));
        Metrics.defaultRegistry().removeMetric(this.factory.createMetricName("TotalBlockedTasks"));
        Metrics.defaultRegistry().removeMetric(this.factory.createMetricName("CurrentlyBlockedTasks"));
        Metrics.defaultRegistry().removeMetric(this.factory.createMetricName("MaxPoolSize"));
    }
}

