/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.metrics;

import java.util.concurrent.ThreadPoolExecutor;
import org.apache.cassandra.metrics.MetricNameFactory;
import org.apache.cassandra.metrics.ThreadPoolMetricNameFactory;
import org.cassandraunit.shaded.com.yammer.metrics.Metrics;
import org.cassandraunit.shaded.com.yammer.metrics.core.Counter;
import org.cassandraunit.shaded.com.yammer.metrics.core.Gauge;

public class ThreadPoolMetrics {
    public final Gauge<Integer> activeTasks;
    public final Counter totalBlocked;
    public final Counter currentBlocked;
    public final Gauge<Long> completedTasks;
    public final Gauge<Long> pendingTasks;
    public final Gauge<Integer> maxPoolSize;
    private MetricNameFactory factory;

    public ThreadPoolMetrics(final ThreadPoolExecutor executor, String path, String poolName) {
        this.factory = new ThreadPoolMetricNameFactory("ThreadPools", path, poolName);
        this.activeTasks = Metrics.newGauge(this.factory.createMetricName("ActiveTasks"), new Gauge<Integer>(){

            @Override
            public Integer value() {
                return executor.getActiveCount();
            }
        });
        this.totalBlocked = Metrics.newCounter(this.factory.createMetricName("TotalBlockedTasks"));
        this.currentBlocked = Metrics.newCounter(this.factory.createMetricName("CurrentlyBlockedTasks"));
        this.completedTasks = Metrics.newGauge(this.factory.createMetricName("CompletedTasks"), new Gauge<Long>(){

            @Override
            public Long value() {
                return executor.getCompletedTaskCount();
            }
        });
        this.pendingTasks = Metrics.newGauge(this.factory.createMetricName("PendingTasks"), new Gauge<Long>(){

            @Override
            public Long value() {
                return executor.getTaskCount() - executor.getCompletedTaskCount();
            }
        });
        this.maxPoolSize = Metrics.newGauge(this.factory.createMetricName("MaxPoolSize"), new Gauge<Integer>(){

            @Override
            public Integer value() {
                return executor.getMaximumPoolSize();
            }
        });
    }

    public void release() {
        Metrics.defaultRegistry().removeMetric(this.factory.createMetricName("ActiveTasks"));
        Metrics.defaultRegistry().removeMetric(this.factory.createMetricName("PendingTasks"));
        Metrics.defaultRegistry().removeMetric(this.factory.createMetricName("CompletedTasks"));
        Metrics.defaultRegistry().removeMetric(this.factory.createMetricName("TotalBlockedTasks"));
        Metrics.defaultRegistry().removeMetric(this.factory.createMetricName("CurrentlyBlockedTasks"));
        Metrics.defaultRegistry().removeMetric(this.factory.createMetricName("MaxPoolSize"));
    }
}

