/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.repair;

import java.io.IOException;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Condition;
import org.apache.cassandra.concurrent.NamedThreadFactory;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.exceptions.RepairException;
import org.apache.cassandra.gms.ApplicationState;
import org.apache.cassandra.gms.EndpointState;
import org.apache.cassandra.gms.FailureDetector;
import org.apache.cassandra.gms.IEndpointStateChangeSubscriber;
import org.apache.cassandra.gms.IFailureDetectionEventListener;
import org.apache.cassandra.gms.VersionedValue;
import org.apache.cassandra.repair.IRepairJobEventListener;
import org.apache.cassandra.repair.NodePair;
import org.apache.cassandra.repair.RepairJob;
import org.apache.cassandra.repair.RepairJobDesc;
import org.apache.cassandra.repair.RepairParallelism;
import org.apache.cassandra.service.ActiveRepairService;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.MerkleTree;
import org.apache.cassandra.utils.UUIDGen;
import org.apache.cassandra.utils.WrappedRunnable;
import org.apache.cassandra.utils.concurrent.SimpleCondition;
import org.cassandraunit.shaded.com.google.common.util.concurrent.ListeningExecutorService;
import org.cassandraunit.shaded.com.google.common.util.concurrent.MoreExecutors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepairSession
extends WrappedRunnable
implements IEndpointStateChangeSubscriber,
IFailureDetectionEventListener,
IRepairJobEventListener {
    private static Logger logger = LoggerFactory.getLogger(RepairSession.class);
    private final UUID id;
    public final String keyspace;
    private final String[] cfnames;
    public final RepairParallelism parallelismDegree;
    public final Range<Token> range;
    public final Set<InetAddress> endpoints;
    private volatile Exception exception;
    private final AtomicBoolean isFailed = new AtomicBoolean(false);
    private final AtomicBoolean fdUnregistered = new AtomicBoolean(false);
    final Queue<RepairJob> jobs = new ConcurrentLinkedQueue<RepairJob>();
    final Map<String, RepairJob> syncingJobs = new ConcurrentHashMap<String, RepairJob>();
    private final ListeningExecutorService taskExecutor = MoreExecutors.listeningDecorator(Executors.newCachedThreadPool(new NamedThreadFactory("RepairJobTask")));
    private final SimpleCondition completed = new SimpleCondition();
    public final Condition differencingDone = new SimpleCondition();
    public final UUID parentRepairSession;
    private volatile boolean terminated = false;

    public RepairSession(UUID parentRepairSession, Range<Token> range, String keyspace, RepairParallelism parallelismDegree, Set<InetAddress> endpoints, String ... cfnames) {
        this(parentRepairSession, UUIDGen.getTimeUUID(), range, keyspace, parallelismDegree, endpoints, cfnames);
    }

    public RepairSession(UUID parentRepairSession, UUID id, Range<Token> range, String keyspace, RepairParallelism parallelismDegree, Set<InetAddress> endpoints, String[] cfnames) {
        this.parentRepairSession = parentRepairSession;
        this.id = id;
        this.parallelismDegree = parallelismDegree;
        this.keyspace = keyspace;
        this.cfnames = cfnames;
        assert (cfnames.length > 0) : "Repairing no column families seems pointless, doesn't it";
        this.range = range;
        this.endpoints = endpoints;
    }

    public UUID getId() {
        return this.id;
    }

    public Range<Token> getRange() {
        return this.range;
    }

    public void validationComplete(RepairJobDesc desc, InetAddress endpoint, MerkleTree tree) {
        RepairJob job = this.jobs.peek();
        if (job == null) {
            assert (this.terminated);
            return;
        }
        if (tree == null) {
            this.exception = new RepairException(desc, "Validation failed in " + endpoint);
            this.forceShutdown();
            return;
        }
        logger.info(String.format("[repair #%s] Received merkle tree for %s from %s", this.getId(), desc.columnFamily, endpoint));
        assert (job.desc.equals(desc));
        if (job.addTree(endpoint, tree) == 0) {
            logger.debug("All responses received for {}/{}", (Object)this.getId(), (Object)desc.columnFamily);
            if (!job.isFailed()) {
                this.syncingJobs.put(job.desc.columnFamily, job);
                job.submitDifferencers();
            }
            this.jobs.poll();
            RepairJob nextJob = this.jobs.peek();
            if (nextJob == null) {
                if (this.fdUnregistered.compareAndSet(false, true)) {
                    FailureDetector.instance.unregisterFailureDetectionEventListener(this);
                }
                this.differencingDone.signalAll();
            } else {
                nextJob.sendTreeRequests(this.endpoints);
            }
        }
    }

    public void syncComplete(RepairJobDesc desc, NodePair nodes, boolean success) {
        RepairJob job = this.syncingJobs.get(desc.columnFamily);
        if (job == null) {
            assert (this.terminated);
            return;
        }
        if (!success) {
            this.exception = new RepairException(desc, String.format("Sync failed between %s and %s", nodes.endpoint1, nodes.endpoint2));
            this.forceShutdown();
            return;
        }
        logger.debug(String.format("[repair #%s] Repair completed between %s and %s on %s", this.getId(), nodes.endpoint1, nodes.endpoint2, desc.columnFamily));
        if (job.completedSynchronization()) {
            String remaining;
            RepairJob completedJob = this.syncingJobs.remove(job.desc.columnFamily);
            String string = remaining = this.syncingJobs.size() == 0 ? "" : String.format(" (%d remaining column family to sync for this session)", this.syncingJobs.size());
            if (completedJob != null && completedJob.isFailed()) {
                logger.warn(String.format("[repair #%s] %s sync failed%s", this.getId(), desc.columnFamily, remaining));
            } else {
                logger.info(String.format("[repair #%s] %s is fully synced%s", this.getId(), desc.columnFamily, remaining));
            }
            if (this.jobs.isEmpty() && this.syncingJobs.isEmpty()) {
                this.taskExecutor.shutdown();
                this.completed.signalAll();
            }
        }
    }

    private String repairedNodes() {
        StringBuilder sb = new StringBuilder();
        sb.append(FBUtilities.getBroadcastAddress());
        for (InetAddress ep : this.endpoints) {
            sb.append(", ").append(ep);
        }
        return sb.toString();
    }

    @Override
    public void runMayThrow() throws Exception {
        block10: {
            logger.info(String.format("[repair #%s] new session: will sync %s on range %s for %s.%s", this.getId(), this.repairedNodes(), this.range, this.keyspace, Arrays.toString(this.cfnames)));
            if (this.endpoints.isEmpty()) {
                this.differencingDone.signalAll();
                logger.info(String.format("[repair #%s] No neighbors to repair with on range %s: session completed", this.getId(), this.range));
                return;
            }
            for (InetAddress endpoint : this.endpoints) {
                if (FailureDetector.instance.isAlive(endpoint)) continue;
                String message = String.format("Cannot proceed on repair because a neighbor (%s) is dead: session failed", endpoint);
                this.differencingDone.signalAll();
                logger.error("[repair #{}] {}", (Object)this.getId(), (Object)message);
                throw new IOException(message);
            }
            ActiveRepairService.instance.addToActiveSessions(this);
            try {
                for (String cfname : this.cfnames) {
                    RepairJob job = new RepairJob(this, this.parentRepairSession, this.id, this.keyspace, cfname, this.range, this.parallelismDegree, this.taskExecutor);
                    this.jobs.offer(job);
                }
                logger.debug("Sending tree requests to endpoints {}", this.endpoints);
                this.jobs.peek().sendTreeRequests(this.endpoints);
                this.completed.await();
                if (this.exception == null) {
                    logger.info(String.format("[repair #%s] session completed successfully", this.getId()));
                    break block10;
                }
                logger.error(String.format("[repair #%s] session completed with the following error", this.getId()), (Throwable)this.exception);
                throw this.exception;
            }
            catch (InterruptedException e) {
                throw new RuntimeException("Interrupted while waiting for repair.");
            }
            finally {
                this.terminate();
                ActiveRepairService.instance.removeFromActiveSessions(this);
                if (this.fdUnregistered.compareAndSet(false, true)) {
                    FailureDetector.instance.unregisterFailureDetectionEventListener(this);
                }
            }
        }
    }

    public void terminate() {
        this.terminated = true;
        this.jobs.clear();
        this.syncingJobs.clear();
    }

    public void forceShutdown() {
        this.taskExecutor.shutdownNow();
        this.differencingDone.signalAll();
        this.completed.signalAll();
    }

    @Override
    public void failedSnapshot() {
        this.exception = new IOException("Failed during snapshot creation.");
        this.forceShutdown();
    }

    void failedNode(InetAddress remote) {
        String errorMsg = String.format("Endpoint %s died", remote);
        this.exception = new IOException(errorMsg);
        this.forceShutdown();
    }

    @Override
    public void onJoin(InetAddress endpoint, EndpointState epState) {
    }

    @Override
    public void beforeChange(InetAddress endpoint, EndpointState currentState, ApplicationState newStateKey, VersionedValue newValue) {
    }

    @Override
    public void onChange(InetAddress endpoint, ApplicationState state, VersionedValue value) {
    }

    @Override
    public void onAlive(InetAddress endpoint, EndpointState state) {
    }

    @Override
    public void onDead(InetAddress endpoint, EndpointState state) {
    }

    @Override
    public void onRemove(InetAddress endpoint) {
        this.convict(endpoint, Double.MAX_VALUE);
    }

    @Override
    public void onRestart(InetAddress endpoint, EndpointState epState) {
        this.convict(endpoint, Double.MAX_VALUE);
    }

    @Override
    public void convict(InetAddress endpoint, double phi) {
        if (!this.endpoints.contains(endpoint)) {
            return;
        }
        if (phi < 2.0 * DatabaseDescriptor.getPhiConvictThreshold()) {
            return;
        }
        if (!this.isFailed.compareAndSet(false, true)) {
            return;
        }
        this.failedNode(endpoint);
    }
}

