/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.transport;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.SynchronousQueue;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import org.apache.cassandra.config.EncryptionOptions;
import org.apache.cassandra.cql3.QueryOptions;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.security.SSLFactory;
import org.apache.cassandra.transport.Connection;
import org.apache.cassandra.transport.Frame;
import org.apache.cassandra.transport.FrameCompressor;
import org.apache.cassandra.transport.Message;
import org.apache.cassandra.transport.messages.CredentialsMessage;
import org.apache.cassandra.transport.messages.ErrorMessage;
import org.apache.cassandra.transport.messages.ExecuteMessage;
import org.apache.cassandra.transport.messages.PrepareMessage;
import org.apache.cassandra.transport.messages.QueryMessage;
import org.apache.cassandra.transport.messages.ResultMessage;
import org.apache.cassandra.transport.messages.StartupMessage;
import org.apache.cassandra.utils.MD5Digest;
import org.cassandraunit.shaded.io.netty.bootstrap.Bootstrap;
import org.cassandraunit.shaded.io.netty.channel.Channel;
import org.cassandraunit.shaded.io.netty.channel.ChannelFuture;
import org.cassandraunit.shaded.io.netty.channel.ChannelHandler;
import org.cassandraunit.shaded.io.netty.channel.ChannelHandlerContext;
import org.cassandraunit.shaded.io.netty.channel.ChannelInitializer;
import org.cassandraunit.shaded.io.netty.channel.ChannelOption;
import org.cassandraunit.shaded.io.netty.channel.ChannelPipeline;
import org.cassandraunit.shaded.io.netty.channel.SimpleChannelInboundHandler;
import org.cassandraunit.shaded.io.netty.channel.nio.NioEventLoopGroup;
import org.cassandraunit.shaded.io.netty.channel.socket.nio.NioSocketChannel;
import org.cassandraunit.shaded.io.netty.handler.ssl.SslHandler;
import org.cassandraunit.shaded.io.netty.util.internal.logging.InternalLoggerFactory;
import org.cassandraunit.shaded.io.netty.util.internal.logging.Slf4JLoggerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleClient {
    private static final Logger logger;
    public final String host;
    public final int port;
    private final EncryptionOptions.ClientEncryptionOptions encryptionOptions;
    protected final ResponseHandler responseHandler = new ResponseHandler();
    protected final Connection.Tracker tracker = new ConnectionTracker();
    protected final Connection connection = new Connection(null, 3, this.tracker);
    protected Bootstrap bootstrap;
    protected Channel channel;
    protected ChannelFuture lastWriteFuture;
    private final Connection.Factory connectionFactory = new Connection.Factory(){

        @Override
        public Connection newConnection(Channel channel, int version) {
            assert (version == 3);
            return SimpleClient.this.connection;
        }
    };
    private static final Message.ProtocolDecoder messageDecoder;
    private static final Message.ProtocolEncoder messageEncoder;
    private static final Frame.Decompressor frameDecompressor;
    private static final Frame.Compressor frameCompressor;
    private static final Frame.Encoder frameEncoder;

    public SimpleClient(String host, int port, EncryptionOptions.ClientEncryptionOptions encryptionOptions) {
        this.host = host;
        this.port = port;
        this.encryptionOptions = encryptionOptions;
    }

    public SimpleClient(String host, int port) {
        this(host, port, new EncryptionOptions.ClientEncryptionOptions());
    }

    public void connect(boolean useCompression) throws IOException {
        this.establishConnection();
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("CQL_VERSION", "3.0.0");
        if (useCompression) {
            options.put("COMPRESSION", "snappy");
            this.connection.setCompressor(FrameCompressor.SnappyCompressor.instance);
        }
        this.execute(new StartupMessage(options));
    }

    protected void establishConnection() throws IOException {
        this.bootstrap = (Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group(new NioEventLoopGroup())).channel(NioSocketChannel.class)).option(ChannelOption.TCP_NODELAY, true);
        if (this.encryptionOptions.enabled) {
            this.bootstrap.handler(new SecureInitializer());
        } else {
            this.bootstrap.handler(new Initializer());
        }
        ChannelFuture future = this.bootstrap.connect(new InetSocketAddress(this.host, this.port));
        this.channel = future.awaitUninterruptibly().channel();
        if (!future.isSuccess()) {
            this.bootstrap.group().shutdownGracefully();
            throw new IOException("Connection Error", future.cause());
        }
    }

    public void login(Map<String, String> credentials) {
        CredentialsMessage msg = new CredentialsMessage();
        msg.credentials.putAll(credentials);
        this.execute(msg);
    }

    public ResultMessage execute(String query, ConsistencyLevel consistency) {
        return this.execute(query, Collections.emptyList(), consistency);
    }

    public ResultMessage execute(String query, List<ByteBuffer> values, ConsistencyLevel consistencyLevel) {
        Message.Response msg = this.execute(new QueryMessage(query, QueryOptions.forInternalCalls(consistencyLevel, values)));
        assert (msg instanceof ResultMessage);
        return (ResultMessage)msg;
    }

    public ResultMessage.Prepared prepare(String query) {
        Message.Response msg = this.execute(new PrepareMessage(query));
        assert (msg instanceof ResultMessage.Prepared);
        return (ResultMessage.Prepared)msg;
    }

    public ResultMessage executePrepared(byte[] statementId, List<ByteBuffer> values, ConsistencyLevel consistency) {
        Message.Response msg = this.execute(new ExecuteMessage(MD5Digest.wrap(statementId), QueryOptions.forInternalCalls(consistency, values)));
        assert (msg instanceof ResultMessage);
        return (ResultMessage)msg;
    }

    public void close() {
        if (this.lastWriteFuture != null) {
            this.lastWriteFuture.awaitUninterruptibly();
        }
        this.channel.close().awaitUninterruptibly();
        this.bootstrap.group().shutdownGracefully();
    }

    protected Message.Response execute(Message.Request request) {
        try {
            request.attach(this.connection);
            this.lastWriteFuture = this.channel.writeAndFlush(request);
            Message.Response msg = this.responseHandler.responses.take();
            if (msg instanceof ErrorMessage) {
                throw new RuntimeException((Throwable)((Object)((ErrorMessage)msg).error));
            }
            return msg;
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        InternalLoggerFactory.setDefaultFactory(new Slf4JLoggerFactory());
        logger = LoggerFactory.getLogger(SimpleClient.class);
        messageDecoder = new Message.ProtocolDecoder();
        messageEncoder = new Message.ProtocolEncoder();
        frameDecompressor = new Frame.Decompressor();
        frameCompressor = new Frame.Compressor();
        frameEncoder = new Frame.Encoder();
    }

    @ChannelHandler.Sharable
    private static class ResponseHandler
    extends SimpleChannelInboundHandler<Message.Response> {
        public final BlockingQueue<Message.Response> responses = new SynchronousQueue<Message.Response>(true);

        private ResponseHandler() {
        }

        @Override
        public void channelRead0(ChannelHandlerContext ctx, Message.Response r) {
            try {
                this.responses.put(r);
            }
            catch (InterruptedException ie) {
                throw new RuntimeException(ie);
            }
        }

        @Override
        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            if (this == ctx.pipeline().last()) {
                logger.error("Exception in response", cause);
            }
            ctx.fireExceptionCaught(cause);
        }
    }

    private class SecureInitializer
    extends Initializer {
        private final SSLContext sslContext;

        public SecureInitializer() throws IOException {
            this.sslContext = SSLFactory.createSSLContext(SimpleClient.this.encryptionOptions, true);
        }

        @Override
        protected void initChannel(Channel channel) throws Exception {
            super.initChannel(channel);
            SSLEngine sslEngine = this.sslContext.createSSLEngine();
            sslEngine.setUseClientMode(true);
            sslEngine.setEnabledCipherSuites(((SimpleClient)SimpleClient.this).encryptionOptions.cipher_suites);
            sslEngine.setEnabledProtocols(SSLFactory.ACCEPTED_PROTOCOLS);
            channel.pipeline().addFirst("ssl", (ChannelHandler)new SslHandler(sslEngine));
        }
    }

    private class Initializer
    extends ChannelInitializer<Channel> {
        private Initializer() {
        }

        @Override
        protected void initChannel(Channel channel) throws Exception {
            ChannelPipeline pipeline = channel.pipeline();
            pipeline.addLast("frameDecoder", (ChannelHandler)new Frame.Decoder(SimpleClient.this.connectionFactory));
            pipeline.addLast("frameEncoder", (ChannelHandler)frameEncoder);
            pipeline.addLast("frameDecompressor", (ChannelHandler)frameDecompressor);
            pipeline.addLast("frameCompressor", (ChannelHandler)frameCompressor);
            pipeline.addLast("messageDecoder", (ChannelHandler)messageDecoder);
            pipeline.addLast("messageEncoder", (ChannelHandler)messageEncoder);
            pipeline.addLast("handler", (ChannelHandler)SimpleClient.this.responseHandler);
        }
    }

    private static class ConnectionTracker
    implements Connection.Tracker {
        private ConnectionTracker() {
        }

        @Override
        public void addConnection(Channel ch, Connection connection) {
        }

        @Override
        public void closeAll() {
        }
    }
}

