/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.transport.messages;

import org.apache.cassandra.transport.Event;
import org.apache.cassandra.transport.Message;
import org.cassandraunit.shaded.io.netty.buffer.ByteBuf;

public class EventMessage
extends Message.Response {
    public static final Message.Codec<EventMessage> codec = new Message.Codec<EventMessage>(){

        @Override
        public EventMessage decode(ByteBuf body, int version) {
            return new EventMessage(Event.deserialize(body, version));
        }

        @Override
        public void encode(EventMessage msg, ByteBuf dest, int version) {
            msg.event.serialize(dest, version);
        }

        @Override
        public int encodedSize(EventMessage msg, int version) {
            return msg.event.serializedSize(version);
        }
    };
    public final Event event;

    public EventMessage(Event event) {
        super(Message.Type.EVENT);
        this.event = event;
        this.setStreamId(-1);
    }

    public String toString() {
        return "EVENT " + this.event;
    }
}

