/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.triggers;

import java.io.File;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.cassandra.config.TriggerDefinition;
import org.apache.cassandra.cql3.QueryProcessor;
import org.apache.cassandra.db.Cell;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.CounterMutation;
import org.apache.cassandra.db.IMutation;
import org.apache.cassandra.db.Mutation;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.triggers.CustomClassLoader;
import org.apache.cassandra.triggers.ITrigger;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.Pair;
import org.cassandraunit.shaded.com.google.common.collect.Iterables;
import org.cassandraunit.shaded.com.google.common.collect.Lists;
import org.cassandraunit.shaded.com.google.common.collect.Maps;

public class TriggerExecutor {
    public static final TriggerExecutor instance = new TriggerExecutor();
    private final Map<String, ITrigger> cachedTriggers = Maps.newConcurrentMap();
    private final ClassLoader parent = Thread.currentThread().getContextClassLoader();
    private volatile ClassLoader customClassLoader;

    private TriggerExecutor() {
        this.reloadClasses();
    }

    public void reloadClasses() {
        File triggerDirectory = FBUtilities.cassandraTriggerDir();
        if (triggerDirectory == null) {
            return;
        }
        this.customClassLoader = new CustomClassLoader(this.parent, triggerDirectory);
        this.cachedTriggers.clear();
    }

    public ColumnFamily execute(ByteBuffer key, ColumnFamily updates) throws InvalidRequestException {
        List<Mutation> intermediate = this.executeInternal(key, updates);
        if (intermediate == null || intermediate.isEmpty()) {
            return updates;
        }
        this.validateForSinglePartition(updates.metadata().getKeyValidator(), updates.id(), key, intermediate);
        for (Mutation mutation : intermediate) {
            for (ColumnFamily cf : mutation.getColumnFamilies()) {
                updates.addAll(cf);
            }
        }
        return updates;
    }

    public Collection<Mutation> execute(Collection<? extends IMutation> mutations) throws InvalidRequestException {
        boolean hasCounters = false;
        LinkedList<Mutation> augmentedMutations = null;
        for (IMutation iMutation : mutations) {
            if (iMutation instanceof CounterMutation) {
                hasCounters = true;
            }
            for (ColumnFamily cf : iMutation.getColumnFamilies()) {
                List<Mutation> augmentations = this.executeInternal(iMutation.key(), cf);
                if (augmentations == null || augmentations.isEmpty()) continue;
                this.validate(augmentations);
                if (augmentedMutations == null) {
                    augmentedMutations = new LinkedList<Mutation>();
                }
                augmentedMutations.addAll(augmentations);
            }
        }
        if (augmentedMutations == null) {
            return null;
        }
        if (hasCounters) {
            throw new InvalidRequestException("Counter mutations and trigger mutations cannot be applied together atomically.");
        }
        Collection<? extends IMutation> originalMutations = mutations;
        return this.mergeMutations(Iterables.concat(originalMutations, augmentedMutations));
    }

    private Collection<Mutation> mergeMutations(Iterable<Mutation> mutations) {
        HashMap<Pair<String, ByteBuffer>, Mutation> groupedMutations = new HashMap<Pair<String, ByteBuffer>, Mutation>();
        for (Mutation mutation : mutations) {
            Pair<String, ByteBuffer> key = Pair.create(mutation.getKeyspaceName(), mutation.key());
            Mutation current = (Mutation)groupedMutations.get(key);
            if (current == null) {
                groupedMutations.put(key, mutation.copy());
                continue;
            }
            current.addAll(mutation);
        }
        return groupedMutations.values();
    }

    private void validateForSinglePartition(AbstractType<?> keyValidator, UUID cfId, ByteBuffer key, Collection<Mutation> tmutations) throws InvalidRequestException {
        for (Mutation mutation : tmutations) {
            if (keyValidator.compare(mutation.key(), key) != 0) {
                throw new InvalidRequestException("Partition key of additional mutation does not match primary update key");
            }
            for (ColumnFamily cf : mutation.getColumnFamilies()) {
                if (cf.id().equals(cfId)) continue;
                throw new InvalidRequestException("Column family of additional mutation does not match primary update cf");
            }
        }
        this.validate(tmutations);
    }

    private void validate(Collection<Mutation> tmutations) throws InvalidRequestException {
        for (Mutation mutation : tmutations) {
            QueryProcessor.validateKey(mutation.key());
            for (ColumnFamily tcf : mutation.getColumnFamilies()) {
                for (Cell cell : tcf) {
                    cell.validateFields(tcf.metadata());
                }
            }
        }
    }

    private List<Mutation> executeInternal(ByteBuffer key, ColumnFamily columnFamily) {
        Map<String, TriggerDefinition> triggers = columnFamily.metadata().getTriggers();
        if (triggers.isEmpty()) {
            return null;
        }
        LinkedList<Mutation> tmutations = Lists.newLinkedList();
        Thread.currentThread().setContextClassLoader(this.customClassLoader);
        try {
            for (TriggerDefinition td : triggers.values()) {
                Collection<Mutation> temp;
                ITrigger trigger = this.cachedTriggers.get(td.classOption);
                if (trigger == null) {
                    trigger = this.loadTriggerInstance(td.classOption);
                    this.cachedTriggers.put(td.classOption, trigger);
                }
                if ((temp = trigger.augment(key, columnFamily)) == null) continue;
                tmutations.addAll(temp);
            }
            LinkedList<Mutation> linkedList = tmutations;
            return linkedList;
        }
        catch (Exception ex) {
            throw new RuntimeException(String.format("Exception while creating trigger on CF with ID: %s", columnFamily.id()), ex);
        }
        finally {
            Thread.currentThread().setContextClassLoader(this.parent);
        }
    }

    public synchronized ITrigger loadTriggerInstance(String triggerName) throws Exception {
        if (this.cachedTriggers.get(triggerName) != null) {
            return this.cachedTriggers.get(triggerName);
        }
        return (ITrigger)this.customClassLoader.loadClass(triggerName).getConstructor(new Class[0]).newInstance(new Object[0]);
    }
}

