/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils;

import java.io.DataInput;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.io.ISerializer;
import org.apache.cassandra.io.IVersionedSerializer;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.utils.Interval;
import org.cassandraunit.shaded.com.google.common.base.Joiner;
import org.cassandraunit.shaded.com.google.common.collect.AbstractIterator;
import org.cassandraunit.shaded.com.google.common.collect.Iterators;
import org.cassandraunit.shaded.com.google.common.collect.Ordering;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IntervalTree<C, D, I extends Interval<C, D>>
implements Iterable<I> {
    private static final Logger logger = LoggerFactory.getLogger(IntervalTree.class);
    private static final IntervalTree EMPTY_TREE = new IntervalTree(null, null);
    private final IntervalNode head;
    private final int count;
    private final Comparator<C> comparator;
    final Ordering<I> minOrdering;
    final Ordering<I> maxOrdering;

    protected IntervalTree(Collection<I> intervals, Comparator<C> comparator) {
        this.comparator = comparator;
        final IntervalTree it = this;
        this.minOrdering = new Ordering<I>(){

            @Override
            public int compare(I interval1, I interval2) {
                return it.comparePoints(((Interval)interval1).min, ((Interval)interval2).min);
            }
        };
        this.maxOrdering = new Ordering<I>(){

            @Override
            public int compare(I interval1, I interval2) {
                return it.comparePoints(((Interval)interval1).max, ((Interval)interval2).max);
            }
        };
        this.head = intervals == null || intervals.isEmpty() ? null : new IntervalNode(intervals);
        this.count = intervals == null ? 0 : intervals.size();
    }

    public static <C, D, I extends Interval<C, D>> IntervalTree<C, D, I> build(Collection<I> intervals, Comparator<C> comparator) {
        if (intervals == null || intervals.isEmpty()) {
            return IntervalTree.emptyTree();
        }
        return new IntervalTree<C, D, I>(intervals, comparator);
    }

    public static <C extends Comparable<C>, D, I extends Interval<C, D>> IntervalTree<C, D, I> build(Collection<I> intervals) {
        if (intervals == null || intervals.isEmpty()) {
            return IntervalTree.emptyTree();
        }
        return new IntervalTree<C, D, I>(intervals, null);
    }

    public static <C, D, I extends Interval<C, D>> Serializer<C, D, I> serializer(ISerializer<C> pointSerializer, ISerializer<D> dataSerializer, Constructor<I> constructor) {
        return new Serializer(pointSerializer, dataSerializer, constructor);
    }

    public static <C, D, I extends Interval<C, D>> IntervalTree<C, D, I> emptyTree() {
        return EMPTY_TREE;
    }

    public Comparator<C> comparator() {
        return this.comparator;
    }

    public int intervalCount() {
        return this.count;
    }

    public boolean isEmpty() {
        return this.head == null;
    }

    public C max() {
        if (this.head == null) {
            throw new IllegalStateException();
        }
        return this.head.high;
    }

    public C min() {
        if (this.head == null) {
            throw new IllegalStateException();
        }
        return this.head.low;
    }

    public List<D> search(Interval<C, D> searchInterval) {
        if (this.head == null) {
            return Collections.emptyList();
        }
        ArrayList results = new ArrayList();
        this.head.searchInternal(searchInterval, results);
        return results;
    }

    public List<D> search(C point) {
        return this.search((C)Interval.create(point, point, null));
    }

    @Override
    public Iterator<I> iterator() {
        if (this.head == null) {
            return Iterators.emptyIterator();
        }
        return new TreeIterator(this.head);
    }

    public String toString() {
        return "<" + Joiner.on(", ").join(this) + ">";
    }

    public boolean equals(Object o) {
        if (!(o instanceof IntervalTree)) {
            return false;
        }
        IntervalTree that = (IntervalTree)o;
        return Iterators.elementsEqual(this.iterator(), that.iterator());
    }

    public final int hashCode() {
        int result = this.comparator.hashCode();
        for (Interval interval : this) {
            result = 31 * result + interval.hashCode();
        }
        return result;
    }

    private int comparePoints(C point1, C point2) {
        if (this.comparator != null) {
            return this.comparator.compare(point1, point2);
        }
        assert (point1 instanceof Comparable);
        assert (point2 instanceof Comparable);
        return ((Comparable)point1).compareTo(point2);
    }

    private boolean encloses(Interval<C, D> enclosing, Interval<C, D> enclosed) {
        return this.comparePoints(enclosing.min, enclosed.min) <= 0 && this.comparePoints(enclosing.max, enclosed.max) >= 0;
    }

    private boolean contains(Interval<C, D> interval, C point) {
        return this.comparePoints(interval.min, point) <= 0 && this.comparePoints(interval.max, point) >= 0;
    }

    private boolean intersects(Interval<C, D> interval1, Interval<C, D> interval2) {
        return this.contains(interval1, interval2.min) || this.contains(interval1, interval2.max);
    }

    public static class Serializer<C, D, I extends Interval<C, D>>
    implements IVersionedSerializer<IntervalTree<C, D, I>> {
        private final ISerializer<C> pointSerializer;
        private final ISerializer<D> dataSerializer;
        private final Constructor<I> constructor;

        private Serializer(ISerializer<C> pointSerializer, ISerializer<D> dataSerializer, Constructor<I> constructor) {
            this.pointSerializer = pointSerializer;
            this.dataSerializer = dataSerializer;
            this.constructor = constructor;
        }

        @Override
        public void serialize(IntervalTree<C, D, I> it, DataOutputPlus out, int version) throws IOException {
            out.writeInt(((IntervalTree)it).count);
            for (Interval interval : it) {
                this.pointSerializer.serialize(interval.min, out);
                this.pointSerializer.serialize(interval.max, out);
                this.dataSerializer.serialize(interval.data, out);
            }
        }

        @Override
        public IntervalTree<C, D, I> deserialize(DataInput in, int version) throws IOException {
            return this.deserialize(in, version, null);
        }

        public IntervalTree<C, D, I> deserialize(DataInput in, int version, Comparator<C> comparator) throws IOException {
            try {
                int count = in.readInt();
                ArrayList<I> intervals = new ArrayList<I>(count);
                for (int i = 0; i < count; ++i) {
                    C min = this.pointSerializer.deserialize(in);
                    C max = this.pointSerializer.deserialize(in);
                    D data = this.dataSerializer.deserialize(in);
                    intervals.add(this.constructor.newInstance(min, max, data));
                }
                return new IntervalTree(intervals, comparator);
            }
            catch (InstantiationException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }

        public long serializedSize(IntervalTree<C, D, I> it, TypeSizes typeSizes, int version) {
            long size = typeSizes.sizeof(0);
            for (Interval interval : it) {
                size += this.pointSerializer.serializedSize(interval.min, typeSizes);
                size += this.pointSerializer.serializedSize(interval.max, typeSizes);
                size += this.dataSerializer.serializedSize(interval.data, typeSizes);
            }
            return size;
        }

        @Override
        public long serializedSize(IntervalTree<C, D, I> it, int version) {
            return this.serializedSize(it, TypeSizes.NATIVE, version);
        }
    }

    private class TreeIterator
    extends AbstractIterator<I> {
        private final Deque<IntervalNode> stack = new ArrayDeque<IntervalNode>();
        private Iterator<I> current;

        TreeIterator(IntervalNode node) {
            this.gotoMinOf(node);
        }

        @Override
        protected I computeNext() {
            if (this.current != null && this.current.hasNext()) {
                return (Interval)this.current.next();
            }
            IntervalNode node = this.stack.pollFirst();
            if (node == null) {
                return (Interval)this.endOfData();
            }
            this.current = node.intersectsLeft.iterator();
            this.gotoMinOf(node.right);
            return this.computeNext();
        }

        private void gotoMinOf(IntervalNode node) {
            while (node != null) {
                this.stack.offerFirst(node);
                node = node.left;
            }
        }
    }

    private class IntervalNode {
        final C center;
        final C low;
        final C high;
        final List<I> intersectsLeft;
        final List<I> intersectsRight;
        final IntervalNode left;
        final IntervalNode right;

        public IntervalNode(Collection<I> toBisect) {
            assert (!toBisect.isEmpty());
            logger.trace("Creating IntervalNode from {}", toBisect);
            if (toBisect.size() == 1) {
                Interval interval = (Interval)toBisect.iterator().next();
                this.low = interval.min;
                this.center = interval.max;
                this.high = interval.max;
                List<Interval> l = Collections.singletonList(interval);
                this.intersectsLeft = l;
                this.intersectsRight = l;
                this.left = null;
                this.right = null;
            } else {
                ArrayList allEndpoints = new ArrayList(toBisect.size() * 2);
                for (Interval interval : toBisect) {
                    assert ((IntervalTree.this.comparator == null ? ((Comparable)interval.min).compareTo(interval.max) : IntervalTree.this.comparator.compare(interval.min, interval.max)) <= 0) : "Interval min > max";
                    allEndpoints.add(interval.min);
                    allEndpoints.add(interval.max);
                }
                if (IntervalTree.this.comparator != null) {
                    Collections.sort(allEndpoints, IntervalTree.this.comparator);
                } else {
                    Collections.sort(allEndpoints);
                }
                this.low = allEndpoints.get(0);
                this.center = allEndpoints.get(toBisect.size());
                this.high = allEndpoints.get(allEndpoints.size() - 1);
                ArrayList<Interval> intersects = new ArrayList<Interval>();
                ArrayList<Interval> leftSegment = new ArrayList<Interval>();
                ArrayList<Interval> rightSegment = new ArrayList<Interval>();
                for (Interval candidate : toBisect) {
                    if (IntervalTree.this.comparePoints(candidate.max, this.center) < 0) {
                        leftSegment.add(candidate);
                        continue;
                    }
                    if (IntervalTree.this.comparePoints(candidate.min, this.center) > 0) {
                        rightSegment.add(candidate);
                        continue;
                    }
                    intersects.add(candidate);
                }
                this.intersectsLeft = IntervalTree.this.minOrdering.sortedCopy(intersects);
                this.intersectsRight = IntervalTree.this.maxOrdering.reverse().sortedCopy(intersects);
                this.left = leftSegment.isEmpty() ? null : new IntervalNode(leftSegment);
                IntervalNode intervalNode = this.right = rightSegment.isEmpty() ? null : new IntervalNode(rightSegment);
                assert (intersects.size() + leftSegment.size() + rightSegment.size() == toBisect.size()) : "intersects (" + String.valueOf(intersects.size()) + ") + leftSegment (" + String.valueOf(leftSegment.size()) + ") + rightSegment (" + String.valueOf(rightSegment.size()) + ") != toBisect (" + String.valueOf(toBisect.size()) + ")";
            }
        }

        void searchInternal(Interval<C, D> searchInterval, List<D> results) {
            if (IntervalTree.this.comparePoints(searchInterval.max, this.low) < 0 || IntervalTree.this.comparePoints(searchInterval.min, this.high) > 0) {
                return;
            }
            if (IntervalTree.this.contains(searchInterval, this.center)) {
                for (Interval interval : this.intersectsLeft) {
                    results.add(interval.data);
                }
                if (this.left != null) {
                    this.left.searchInternal(searchInterval, results);
                }
                if (this.right != null) {
                    this.right.searchInternal(searchInterval, results);
                }
            } else if (IntervalTree.this.comparePoints(this.center, searchInterval.min) < 0) {
                for (Interval interval : this.intersectsRight) {
                    if (IntervalTree.this.comparePoints(interval.max, searchInterval.min) < 0) break;
                    results.add(interval.data);
                }
                if (this.right != null) {
                    this.right.searchInternal(searchInterval, results);
                }
            } else {
                assert (IntervalTree.this.comparePoints(this.center, searchInterval.max) > 0);
                for (Interval interval : this.intersectsLeft) {
                    if (IntervalTree.this.comparePoints(interval.min, searchInterval.max) > 0) break;
                    results.add(interval.data);
                }
                if (this.left != null) {
                    this.left.searchInternal(searchInterval, results);
                }
            }
        }
    }
}

