/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.cassandraunit.shaded.com.google.common.annotations.VisibleForTesting;
import org.cliffc.high_scale_lib.NonBlockingHashMap;
import org.slf4j.Logger;

public class NoSpamLogger {
    @VisibleForTesting
    static Clock CLOCK = new Clock(){

        @Override
        public long nanoTime() {
            return System.nanoTime();
        }
    };
    private static final NonBlockingHashMap<Logger, NoSpamLogger> wrappedLoggers = new NonBlockingHashMap();
    private final Logger wrapped;
    private final long minIntervalNanos;
    private final NonBlockingHashMap<String, NoSpamLogStatement> lastMessage = new NonBlockingHashMap();

    @VisibleForTesting
    static void clearWrappedLoggersForTest() {
        wrappedLoggers.clear();
    }

    public static NoSpamLogger getLogger(Logger logger, long minInterval, TimeUnit unit) {
        NoSpamLogger temp;
        NoSpamLogger wrapped = (NoSpamLogger)wrappedLoggers.get((Object)logger);
        if (wrapped == null && (temp = (NoSpamLogger)wrappedLoggers.putIfAbsent((Object)logger, (Object)(wrapped = new NoSpamLogger(logger, minInterval, unit)))) != null) {
            wrapped = temp;
        }
        return wrapped;
    }

    public static void log(Logger logger, Level level, long minInterval, TimeUnit unit, String message, Object ... objects) {
        NoSpamLogger.log(logger, level, minInterval, unit, CLOCK.nanoTime(), message, objects);
    }

    public static void log(Logger logger, Level level, long minInterval, TimeUnit unit, long nowNanos, String message, Object ... objects) {
        NoSpamLogger wrapped = NoSpamLogger.getLogger(logger, minInterval, unit);
        NoSpamLogStatement statement = wrapped.getStatement(message);
        statement.log(level, nowNanos, objects);
    }

    public static NoSpamLogStatement getStatement(Logger logger, String message, long minInterval, TimeUnit unit) {
        NoSpamLogger wrapped = NoSpamLogger.getLogger(logger, minInterval, unit);
        return wrapped.getStatement(message);
    }

    private NoSpamLogger(Logger wrapped, long minInterval, TimeUnit timeUnit) {
        this.wrapped = wrapped;
        this.minIntervalNanos = timeUnit.toNanos(minInterval);
    }

    public void info(long nowNanos, String s, Object ... objects) {
        this.log(Level.INFO, s, nowNanos, objects);
    }

    public void info(String s, Object ... objects) {
        this.info(CLOCK.nanoTime(), s, objects);
    }

    public void warn(long nowNanos, String s, Object ... objects) {
        this.log(Level.WARN, s, nowNanos, objects);
    }

    public void warn(String s, Object ... objects) {
        this.warn(CLOCK.nanoTime(), s, objects);
    }

    public void error(long nowNanos, String s, Object ... objects) {
        this.log(Level.ERROR, s, nowNanos, objects);
    }

    public void error(String s, Object ... objects) {
        this.error(CLOCK.nanoTime(), s, objects);
    }

    public void log(Level l, String s, long nowNanos, Object ... objects) {
        this.getStatement(s, this.minIntervalNanos).log(l, nowNanos, objects);
    }

    public NoSpamLogStatement getStatement(String s) {
        return this.getStatement(s, this.minIntervalNanos);
    }

    public NoSpamLogStatement getStatement(String s, long minInterval, TimeUnit unit) {
        return this.getStatement(s, unit.toNanos(minInterval));
    }

    public NoSpamLogStatement getStatement(String s, long minIntervalNanos) {
        NoSpamLogStatement temp;
        NoSpamLogStatement statement = (NoSpamLogStatement)this.lastMessage.get((Object)s);
        if (statement == null && (temp = (NoSpamLogStatement)this.lastMessage.putIfAbsent((Object)s, (Object)(statement = new NoSpamLogStatement(s, minIntervalNanos)))) != null) {
            statement = temp;
        }
        return statement;
    }

    public class NoSpamLogStatement
    extends AtomicLong {
        private static final long serialVersionUID = 1L;
        private final String statement;
        private final long minIntervalNanos;

        public NoSpamLogStatement(String statement, long minIntervalNanos) {
            this.statement = statement;
            this.minIntervalNanos = minIntervalNanos;
        }

        private boolean shouldLog(long nowNanos) {
            long expected = this.get();
            return nowNanos - expected >= this.minIntervalNanos && this.compareAndSet(expected, nowNanos);
        }

        public void log(Level l, long nowNanos, Object ... objects) {
            if (!this.shouldLog(nowNanos)) {
                return;
            }
            switch (l) {
                case INFO: {
                    NoSpamLogger.this.wrapped.info(this.statement, objects);
                    break;
                }
                case WARN: {
                    NoSpamLogger.this.wrapped.warn(this.statement, objects);
                    break;
                }
                case ERROR: {
                    NoSpamLogger.this.wrapped.error(this.statement, objects);
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }

        public void info(long nowNanos, Object ... objects) {
            this.log(Level.INFO, nowNanos, objects);
        }

        public void info(Object ... objects) {
            this.info(CLOCK.nanoTime(), objects);
        }

        public void warn(long nowNanos, Object ... objects) {
            this.log(Level.WARN, nowNanos, objects);
        }

        public void warn(Object ... objects) {
            this.warn(CLOCK.nanoTime(), objects);
        }

        public void error(long nowNanos, Object ... objects) {
            this.log(Level.ERROR, nowNanos, objects);
        }

        public void error(Object ... objects) {
            this.error(CLOCK.nanoTime(), objects);
        }
    }

    @VisibleForTesting
    static interface Clock {
        public long nanoTime();
    }

    public static enum Level {
        INFO,
        WARN,
        ERROR;

    }
}

