/*
 * Decompiled with CFR 0.152.
 */
package org.cassandraunit.shaded.com.addthis.metrics.reporter.config;

import java.util.ArrayList;
import java.util.List;
import javax.validation.Valid;
import org.cassandraunit.shaded.com.addthis.metrics.reporter.config.AbstractReporterConfig;
import org.cassandraunit.shaded.com.addthis.metrics.reporter.config.HostPort;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractHostPortReporterConfig
extends AbstractReporterConfig {
    private static final Logger log = LoggerFactory.getLogger(AbstractHostPortReporterConfig.class);
    @Valid
    private List<HostPort> hosts;
    @Valid
    private String hostsString;

    public List<HostPort> getHosts() {
        return this.hosts;
    }

    public void setHosts(List<HostPort> hosts) {
        this.hosts = hosts;
    }

    public String getHostsString() {
        return this.hostsString;
    }

    public void setHostsString(String hostsString) {
        this.hostsString = hostsString;
    }

    public List<HostPort> parseHostString() {
        ArrayList<HostPort> hosts = new ArrayList<HostPort>();
        String[] hostPairs = this.getHostsString().split(",");
        for (int i = 0; i < hostPairs.length; ++i) {
            String[] pair = hostPairs[i].split(":");
            hosts.add(new HostPort(pair[0], Integer.valueOf(pair[1])));
        }
        return hosts;
    }

    public List<HostPort> getHostListAndStringList() {
        if (this.getHosts() == null && this.getHostsString() == null) {
            log.warn("No hosts specified as a list or delimited string");
            return null;
        }
        if (this.getHosts() != null && this.getHostsString() != null) {
            log.warn("Did you really mean to have hosts as a list and delimited string?");
        }
        ArrayList<HostPort> combinedHosts = new ArrayList<HostPort>();
        if (this.getHosts() != null) {
            combinedHosts.addAll(this.getHosts());
        }
        if (this.getHostsString() != null) {
            combinedHosts.addAll(this.parseHostString());
        }
        return combinedHosts;
    }

    public abstract List<HostPort> getFullHostList();
}

