/*
 * Decompiled with CFR 0.152.
 */
package org.cassandraunit.shaded.com.addthis.metrics.reporter.config;

import java.io.PrintStream;
import org.cassandraunit.shaded.com.addthis.metrics.reporter.config.AbstractReporterConfig;
import org.cassandraunit.shaded.com.yammer.metrics.Metrics;
import org.cassandraunit.shaded.com.yammer.metrics.reporting.ConsoleReporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsoleReporterConfig
extends AbstractReporterConfig {
    private static final Logger log = LoggerFactory.getLogger(ConsoleReporterConfig.class);
    private String outfile = null;

    public String getOutfile() {
        return this.outfile;
    }

    public void setOutfile(String outfile) {
        this.outfile = outfile;
    }

    @Override
    public boolean enable() {
        try {
            PrintStream stream = null;
            if (this.outfile != null) {
                log.info("console reporting will be redirected to {} instead of stdout", (Object)this.outfile);
                stream = new PrintStream(this.outfile);
            } else {
                stream = System.out;
            }
            ConsoleReporter reporter = new ConsoleReporter(Metrics.defaultRegistry(), stream, this.getMetricPredicate());
            reporter.start(this.getPeriod(), this.getRealTimeunit());
        }
        catch (Exception e) {
            log.error("Failure while enabling console reporter", (Throwable)e);
            return false;
        }
        return true;
    }
}

