/*
 * Decompiled with CFR 0.152.
 */
package org.cassandraunit.shaded.com.addthis.metrics.reporter.config;

import java.io.File;
import javax.validation.constraints.NotNull;
import org.cassandraunit.shaded.com.addthis.metrics.reporter.config.AbstractReporterConfig;
import org.cassandraunit.shaded.com.yammer.metrics.Metrics;
import org.cassandraunit.shaded.com.yammer.metrics.reporting.CsvReporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CsvReporterConfig
extends AbstractReporterConfig {
    private static final Logger log = LoggerFactory.getLogger(CsvReporterConfig.class);
    @NotNull
    private String outdir;

    public String getOutdir() {
        return this.outdir;
    }

    public void setOutdir(String outdir) {
        this.outdir = outdir;
    }

    @Override
    public boolean enable() {
        log.info("Enabling CsvReporter to {}", (Object)this.outdir);
        try {
            File foutDir = new File(this.outdir);
            boolean success = foutDir.mkdirs();
            if (!success) {
                log.error("Failed to create directory {} for CsvReporter", (Object)this.outdir);
                return false;
            }
            CsvReporter reporter = new CsvReporter(Metrics.defaultRegistry(), this.getMetricPredicate(), foutDir);
            reporter.start(this.getPeriod(), this.getRealTimeunit());
        }
        catch (Exception e) {
            log.error("Failure while Enabling CsvReporter", (Throwable)e);
            return false;
        }
        return true;
    }
}

