/*
 * Decompiled with CFR 0.152.
 */
package org.cassandraunit.shaded.com.addthis.metrics.reporter.config;

import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.validation.constraints.NotNull;
import org.cassandraunit.shaded.com.addthis.metrics.reporter.config.AbstractHostPortReporterConfig;
import org.cassandraunit.shaded.com.addthis.metrics.reporter.config.GmondConfigParser;
import org.cassandraunit.shaded.com.addthis.metrics.reporter.config.HostPort;
import org.cassandraunit.shaded.com.yammer.metrics.Metrics;
import org.cassandraunit.shaded.com.yammer.metrics.core.MetricPredicate;
import org.cassandraunit.shaded.com.yammer.metrics.core.MetricsRegistry;
import org.cassandraunit.shaded.com.yammer.metrics.reporting.GangliaReporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GangliaReporterConfig
extends AbstractHostPortReporterConfig {
    private static final Logger log = LoggerFactory.getLogger(GangliaReporterConfig.class);
    @NotNull
    private String groupPrefix = "";
    @NotNull
    private boolean compressPackageNames = false;
    private String gmondConf;

    public String getGroupPrefix() {
        return this.groupPrefix;
    }

    public void setGroupPrefix(String groupPrefix) {
        this.groupPrefix = groupPrefix;
    }

    public boolean getCompressPackageNames() {
        return this.compressPackageNames;
    }

    public void setCompressPackageNames(boolean compressPackageNames) {
        this.compressPackageNames = compressPackageNames;
    }

    public String getGmondConf() {
        return this.gmondConf;
    }

    public void setGmondConf(String gmondConf) {
        this.gmondConf = gmondConf;
    }

    @Override
    public List<HostPort> getFullHostList() {
        if (this.gmondConf != null) {
            GmondConfigParser gcp = new GmondConfigParser();
            List<HostPort> confHosts = gcp.getGmondSendChannels(this.gmondConf);
            if (confHosts == null || confHosts.isEmpty()) {
                log.warn("No send channels found after reading {}", (Object)this.gmondConf);
            }
            return confHosts;
        }
        return this.getHostListAndStringList();
    }

    @Override
    public boolean enable() {
        String className = "org.cassandraunit.shaded.com.yammer.metrics.reporting.GangliaReporter";
        if (!this.isClassAvailable(className)) {
            log.error("Tried to enable GangliaReporter, but class {} was not found", (Object)className);
            return false;
        }
        List<HostPort> hosts = this.getFullHostList();
        if (hosts == null || hosts.isEmpty()) {
            log.error("No hosts specified, cannot enable GangliaReporter");
            return false;
        }
        for (HostPort hostPort : hosts) {
            log.info("Enabling GangliaReporter to {}:{}", new Object[]{hostPort.getHost(), hostPort.getPort()});
            try {
                GangliaReporter.enable((MetricsRegistry)Metrics.defaultRegistry(), (long)this.getPeriod(), (TimeUnit)this.getRealTimeunit(), (String)hostPort.getHost(), (int)hostPort.getPort(), (String)this.groupPrefix, (MetricPredicate)this.getMetricPredicate(), (boolean)this.compressPackageNames);
            }
            catch (Exception e) {
                log.error("Faliure while enabling GangliaReporter", (Throwable)e);
                return false;
            }
        }
        return true;
    }
}

