/*
 * Decompiled with CFR 0.152.
 */
package org.cassandraunit.shaded.com.addthis.metrics.reporter.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.validation.ConstraintViolation;
import javax.validation.Valid;
import javax.validation.Validation;
import javax.validation.ValidatorFactory;
import org.cassandraunit.shaded.com.addthis.metrics.reporter.config.ConsoleReporterConfig;
import org.cassandraunit.shaded.com.addthis.metrics.reporter.config.CsvReporterConfig;
import org.cassandraunit.shaded.com.addthis.metrics.reporter.config.GangliaReporterConfig;
import org.cassandraunit.shaded.com.addthis.metrics.reporter.config.GraphiteReporterConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Constructor;

public class ReporterConfig {
    private static final Logger log = LoggerFactory.getLogger(ReporterConfig.class);
    @Valid
    private List<ConsoleReporterConfig> console;
    @Valid
    private List<CsvReporterConfig> csv;
    @Valid
    private List<GangliaReporterConfig> ganglia;
    @Valid
    private List<GraphiteReporterConfig> graphite;

    public List<ConsoleReporterConfig> getConsole() {
        return this.console;
    }

    public void setConsole(List<ConsoleReporterConfig> console) {
        this.console = console;
    }

    public List<CsvReporterConfig> getCsv() {
        return this.csv;
    }

    public void setCsv(List<CsvReporterConfig> csv) {
        this.csv = csv;
    }

    public List<GangliaReporterConfig> getGanglia() {
        return this.ganglia;
    }

    public void setGanglia(List<GangliaReporterConfig> ganglia) {
        this.ganglia = ganglia;
    }

    public List<GraphiteReporterConfig> getGraphite() {
        return this.graphite;
    }

    public void setGraphite(List<GraphiteReporterConfig> graphite) {
        this.graphite = graphite;
    }

    public boolean enableConsole() {
        boolean failures = false;
        if (this.console == null) {
            log.debug("Asked to enable console, but it was not configured");
            return false;
        }
        for (ConsoleReporterConfig consoleConfig : this.console) {
            if (consoleConfig.enable()) continue;
            failures = true;
        }
        return !failures;
    }

    public boolean enableCsv() {
        boolean failures = false;
        if (this.csv == null) {
            log.debug("Asked to enable csv, but it was not configured");
            return false;
        }
        for (CsvReporterConfig csvConfig : this.csv) {
            if (csvConfig.enable()) continue;
            failures = true;
        }
        return !failures;
    }

    public boolean enableGanglia() {
        boolean failures = false;
        if (this.ganglia == null) {
            log.debug("Asked to enable ganglia, but it was not configured");
            return false;
        }
        for (GangliaReporterConfig gangliaConfig : this.ganglia) {
            if (gangliaConfig.enable()) continue;
            failures = true;
        }
        return !failures;
    }

    public boolean enableGraphite() {
        boolean failures = false;
        if (this.graphite == null) {
            log.debug("Asked to enable graphite, but it was not configured");
            return false;
        }
        for (GraphiteReporterConfig graphiteConfig : this.graphite) {
            if (graphiteConfig.enable()) continue;
            failures = true;
        }
        return !failures;
    }

    public boolean enableAll() {
        boolean enabled = false;
        if (this.console != null && this.enableConsole()) {
            enabled = true;
        }
        if (this.csv != null && this.enableCsv()) {
            enabled = true;
        }
        if (this.ganglia != null && this.enableGanglia()) {
            enabled = true;
        }
        if (this.graphite != null && this.enableGraphite()) {
            enabled = true;
        }
        if (!enabled) {
            log.warn("No reporters were succesfully enabled");
        }
        return enabled;
    }

    public static ReporterConfig loadFromFileAndValidate(String fileName) throws IOException {
        ReporterConfig config = ReporterConfig.loadFromFile(fileName);
        if (ReporterConfig.validate(config)) {
            return config;
        }
        throw new ReporterConfigurationException("configuration failed validation");
    }

    public static ReporterConfig loadFromFile(String fileName) throws IOException {
        Yaml yaml = new Yaml((BaseConstructor)new Constructor(ReporterConfig.class));
        FileInputStream input = new FileInputStream(new File(fileName));
        ReporterConfig config = (ReporterConfig)yaml.load((InputStream)input);
        return config;
    }

    public static <T> boolean validate(T obj) {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Set violations = factory.getValidator().validate(obj, new Class[0]);
        TreeSet<String> errors = new TreeSet<String>();
        for (ConstraintViolation v : violations) {
            errors.add(String.format("%s %s (was %s)", v.getPropertyPath(), v.getMessage(), v.getInvalidValue()));
        }
        if (errors.isEmpty()) {
            return true;
        }
        log.error("Failed to validate: {}", errors);
        return false;
    }

    public static class ReporterConfigurationException
    extends RuntimeException {
        public ReporterConfigurationException(String msg) {
            super(msg);
        }
    }
}

