/*
 * Decompiled with CFR 0.152.
 */
package org.cassandraunit.shaded.com.yammer.metrics;

import java.util.concurrent.TimeUnit;
import org.cassandraunit.shaded.com.yammer.metrics.core.Counter;
import org.cassandraunit.shaded.com.yammer.metrics.core.Gauge;
import org.cassandraunit.shaded.com.yammer.metrics.core.Histogram;
import org.cassandraunit.shaded.com.yammer.metrics.core.Meter;
import org.cassandraunit.shaded.com.yammer.metrics.core.MetricName;
import org.cassandraunit.shaded.com.yammer.metrics.core.MetricsRegistry;
import org.cassandraunit.shaded.com.yammer.metrics.core.Timer;
import org.cassandraunit.shaded.com.yammer.metrics.reporting.JmxReporter;

public class Metrics {
    private static final MetricsRegistry DEFAULT_REGISTRY = new MetricsRegistry();
    private static final Thread SHUTDOWN_HOOK = new Thread(){

        @Override
        public void run() {
            JmxReporter.shutdownDefault();
        }
    };

    private Metrics() {
    }

    public static <T> Gauge<T> newGauge(Class<?> klass, String name, Gauge<T> metric) {
        return DEFAULT_REGISTRY.newGauge(klass, name, metric);
    }

    public static <T> Gauge<T> newGauge(Class<?> klass, String name, String scope, Gauge<T> metric) {
        return DEFAULT_REGISTRY.newGauge(klass, name, scope, metric);
    }

    public static <T> Gauge<T> newGauge(MetricName metricName, Gauge<T> metric) {
        return DEFAULT_REGISTRY.newGauge(metricName, metric);
    }

    public static Counter newCounter(Class<?> klass, String name) {
        return DEFAULT_REGISTRY.newCounter(klass, name);
    }

    public static Counter newCounter(Class<?> klass, String name, String scope) {
        return DEFAULT_REGISTRY.newCounter(klass, name, scope);
    }

    public static Counter newCounter(MetricName metricName) {
        return DEFAULT_REGISTRY.newCounter(metricName);
    }

    public static Histogram newHistogram(Class<?> klass, String name, boolean biased) {
        return DEFAULT_REGISTRY.newHistogram(klass, name, biased);
    }

    public static Histogram newHistogram(Class<?> klass, String name, String scope, boolean biased) {
        return DEFAULT_REGISTRY.newHistogram(klass, name, scope, biased);
    }

    public static Histogram newHistogram(MetricName metricName, boolean biased) {
        return DEFAULT_REGISTRY.newHistogram(metricName, biased);
    }

    public static Histogram newHistogram(Class<?> klass, String name) {
        return DEFAULT_REGISTRY.newHistogram(klass, name);
    }

    public static Histogram newHistogram(Class<?> klass, String name, String scope) {
        return DEFAULT_REGISTRY.newHistogram(klass, name, scope);
    }

    public static Histogram newHistogram(MetricName metricName) {
        return Metrics.newHistogram(metricName, false);
    }

    public static Meter newMeter(Class<?> klass, String name, String eventType, TimeUnit unit) {
        return DEFAULT_REGISTRY.newMeter(klass, name, eventType, unit);
    }

    public static Meter newMeter(Class<?> klass, String name, String scope, String eventType, TimeUnit unit) {
        return DEFAULT_REGISTRY.newMeter(klass, name, scope, eventType, unit);
    }

    public static Meter newMeter(MetricName metricName, String eventType, TimeUnit unit) {
        return DEFAULT_REGISTRY.newMeter(metricName, eventType, unit);
    }

    public static Timer newTimer(Class<?> klass, String name, TimeUnit durationUnit, TimeUnit rateUnit) {
        return DEFAULT_REGISTRY.newTimer(klass, name, durationUnit, rateUnit);
    }

    public static Timer newTimer(Class<?> klass, String name) {
        return DEFAULT_REGISTRY.newTimer(klass, name);
    }

    public static Timer newTimer(Class<?> klass, String name, String scope, TimeUnit durationUnit, TimeUnit rateUnit) {
        return DEFAULT_REGISTRY.newTimer(klass, name, scope, durationUnit, rateUnit);
    }

    public static Timer newTimer(Class<?> klass, String name, String scope) {
        return DEFAULT_REGISTRY.newTimer(klass, name, scope);
    }

    public static Timer newTimer(MetricName metricName, TimeUnit durationUnit, TimeUnit rateUnit) {
        return DEFAULT_REGISTRY.newTimer(metricName, durationUnit, rateUnit);
    }

    public static MetricsRegistry defaultRegistry() {
        return DEFAULT_REGISTRY;
    }

    public static void shutdown() {
        DEFAULT_REGISTRY.shutdown();
        JmxReporter.shutdownDefault();
        Runtime.getRuntime().removeShutdownHook(SHUTDOWN_HOOK);
    }

    static {
        JmxReporter.startDefault(DEFAULT_REGISTRY);
        Runtime.getRuntime().addShutdownHook(SHUTDOWN_HOOK);
    }
}

