/*
 * Decompiled with CFR 0.152.
 */
package org.cassandraunit.shaded.io.netty.handler.codec.http;

import java.util.List;
import org.cassandraunit.shaded.io.netty.buffer.ByteBuf;
import org.cassandraunit.shaded.io.netty.buffer.CompositeByteBuf;
import org.cassandraunit.shaded.io.netty.buffer.DefaultByteBufHolder;
import org.cassandraunit.shaded.io.netty.buffer.Unpooled;
import org.cassandraunit.shaded.io.netty.channel.ChannelFuture;
import org.cassandraunit.shaded.io.netty.channel.ChannelFutureListener;
import org.cassandraunit.shaded.io.netty.channel.ChannelHandlerContext;
import org.cassandraunit.shaded.io.netty.handler.codec.DecoderResult;
import org.cassandraunit.shaded.io.netty.handler.codec.MessageToMessageDecoder;
import org.cassandraunit.shaded.io.netty.handler.codec.TooLongFrameException;
import org.cassandraunit.shaded.io.netty.handler.codec.http.DefaultFullHttpRequest;
import org.cassandraunit.shaded.io.netty.handler.codec.http.DefaultFullHttpResponse;
import org.cassandraunit.shaded.io.netty.handler.codec.http.DefaultHttpHeaders;
import org.cassandraunit.shaded.io.netty.handler.codec.http.FullHttpMessage;
import org.cassandraunit.shaded.io.netty.handler.codec.http.FullHttpRequest;
import org.cassandraunit.shaded.io.netty.handler.codec.http.FullHttpResponse;
import org.cassandraunit.shaded.io.netty.handler.codec.http.HttpContent;
import org.cassandraunit.shaded.io.netty.handler.codec.http.HttpHeaders;
import org.cassandraunit.shaded.io.netty.handler.codec.http.HttpMessage;
import org.cassandraunit.shaded.io.netty.handler.codec.http.HttpMethod;
import org.cassandraunit.shaded.io.netty.handler.codec.http.HttpObject;
import org.cassandraunit.shaded.io.netty.handler.codec.http.HttpRequest;
import org.cassandraunit.shaded.io.netty.handler.codec.http.HttpResponse;
import org.cassandraunit.shaded.io.netty.handler.codec.http.HttpResponseStatus;
import org.cassandraunit.shaded.io.netty.handler.codec.http.HttpVersion;
import org.cassandraunit.shaded.io.netty.handler.codec.http.LastHttpContent;

public class HttpObjectAggregator
extends MessageToMessageDecoder<HttpObject> {
    public static final int DEFAULT_MAX_COMPOSITEBUFFER_COMPONENTS = 1024;
    private static final FullHttpResponse CONTINUE = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.CONTINUE, Unpooled.EMPTY_BUFFER);
    private final int maxContentLength;
    private AggregatedFullHttpMessage currentMessage;
    private boolean tooLongFrameFound;
    private int maxCumulationBufferComponents = 1024;
    private ChannelHandlerContext ctx;

    public HttpObjectAggregator(int maxContentLength) {
        if (maxContentLength <= 0) {
            throw new IllegalArgumentException("maxContentLength must be a positive integer: " + maxContentLength);
        }
        this.maxContentLength = maxContentLength;
    }

    public final int getMaxCumulationBufferComponents() {
        return this.maxCumulationBufferComponents;
    }

    public final void setMaxCumulationBufferComponents(int maxCumulationBufferComponents) {
        if (maxCumulationBufferComponents < 2) {
            throw new IllegalArgumentException("maxCumulationBufferComponents: " + maxCumulationBufferComponents + " (expected: >= 2)");
        }
        if (this.ctx != null) {
            throw new IllegalStateException("decoder properties cannot be changed once the decoder is added to a pipeline.");
        }
        this.maxCumulationBufferComponents = maxCumulationBufferComponents;
    }

    @Override
    protected void decode(final ChannelHandlerContext ctx, HttpObject msg, List<Object> out) throws Exception {
        AggregatedFullHttpMessage currentMessage = this.currentMessage;
        if (msg instanceof HttpMessage) {
            this.tooLongFrameFound = false;
            assert (currentMessage == null);
            HttpMessage m = (HttpMessage)msg;
            if (HttpHeaders.is100ContinueExpected(m)) {
                ctx.writeAndFlush(CONTINUE).addListener(new ChannelFutureListener(){

                    @Override
                    public void operationComplete(ChannelFuture future) throws Exception {
                        if (!future.isSuccess()) {
                            ctx.fireExceptionCaught(future.cause());
                        }
                    }
                });
            }
            if (!m.getDecoderResult().isSuccess()) {
                HttpHeaders.removeTransferEncodingChunked(m);
                out.add(HttpObjectAggregator.toFullMessage(m));
                this.currentMessage = null;
                return;
            }
            if (msg instanceof HttpRequest) {
                HttpRequest header = (HttpRequest)msg;
                this.currentMessage = currentMessage = new AggregatedFullHttpRequest(header, (ByteBuf)ctx.alloc().compositeBuffer(this.maxCumulationBufferComponents), null);
            } else if (msg instanceof HttpResponse) {
                HttpResponse header = (HttpResponse)msg;
                this.currentMessage = currentMessage = new AggregatedFullHttpResponse(header, (ByteBuf)Unpooled.compositeBuffer(this.maxCumulationBufferComponents), null);
            } else {
                throw new Error();
            }
            HttpHeaders.removeTransferEncodingChunked(currentMessage);
        } else if (msg instanceof HttpContent) {
            boolean last;
            if (this.tooLongFrameFound) {
                if (msg instanceof LastHttpContent) {
                    this.currentMessage = null;
                }
                return;
            }
            assert (currentMessage != null);
            HttpContent chunk = (HttpContent)msg;
            CompositeByteBuf content = (CompositeByteBuf)currentMessage.content();
            if (content.readableBytes() > this.maxContentLength - chunk.content().readableBytes()) {
                this.tooLongFrameFound = true;
                currentMessage.release();
                this.currentMessage = null;
                throw new TooLongFrameException("HTTP content length exceeded " + this.maxContentLength + " bytes.");
            }
            if (chunk.content().isReadable()) {
                chunk.retain();
                content.addComponent(chunk.content());
                content.writerIndex(content.writerIndex() + chunk.content().readableBytes());
            }
            if (!chunk.getDecoderResult().isSuccess()) {
                currentMessage.setDecoderResult(DecoderResult.failure(chunk.getDecoderResult().cause()));
                last = true;
            } else {
                last = chunk instanceof LastHttpContent;
            }
            if (last) {
                this.currentMessage = null;
                if (chunk instanceof LastHttpContent) {
                    LastHttpContent trailer = (LastHttpContent)chunk;
                    currentMessage.setTrailingHeaders(trailer.trailingHeaders());
                } else {
                    currentMessage.setTrailingHeaders(new DefaultHttpHeaders());
                }
                currentMessage.headers().set("Content-Length", (Object)String.valueOf(content.readableBytes()));
                out.add(currentMessage);
            }
        } else {
            throw new Error();
        }
    }

    @Override
    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        super.channelInactive(ctx);
        if (this.currentMessage != null) {
            this.currentMessage.release();
            this.currentMessage = null;
        }
    }

    @Override
    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        this.ctx = ctx;
    }

    @Override
    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        super.handlerRemoved(ctx);
        if (this.currentMessage != null) {
            this.currentMessage.release();
            this.currentMessage = null;
        }
    }

    private static FullHttpMessage toFullMessage(HttpMessage msg) {
        AggregatedFullHttpMessage fullMsg;
        if (msg instanceof FullHttpMessage) {
            return ((FullHttpMessage)msg).retain();
        }
        if (msg instanceof HttpRequest) {
            fullMsg = new AggregatedFullHttpRequest((HttpRequest)msg, Unpooled.EMPTY_BUFFER, (HttpHeaders)new DefaultHttpHeaders());
        } else if (msg instanceof HttpResponse) {
            fullMsg = new AggregatedFullHttpResponse((HttpResponse)msg, Unpooled.EMPTY_BUFFER, (HttpHeaders)new DefaultHttpHeaders());
        } else {
            throw new IllegalStateException();
        }
        return fullMsg;
    }

    private static final class AggregatedFullHttpResponse
    extends AggregatedFullHttpMessage
    implements FullHttpResponse {
        private AggregatedFullHttpResponse(HttpResponse message, ByteBuf content, HttpHeaders trailingHeaders) {
            super(message, content, trailingHeaders);
        }

        @Override
        public FullHttpResponse copy() {
            DefaultFullHttpResponse copy = new DefaultFullHttpResponse(this.getProtocolVersion(), this.getStatus(), this.content().copy());
            copy.headers().set(this.headers());
            copy.trailingHeaders().set(this.trailingHeaders());
            return copy;
        }

        @Override
        public FullHttpResponse duplicate() {
            DefaultFullHttpResponse duplicate = new DefaultFullHttpResponse(this.getProtocolVersion(), this.getStatus(), this.content().duplicate());
            duplicate.headers().set(this.headers());
            duplicate.trailingHeaders().set(this.trailingHeaders());
            return duplicate;
        }

        @Override
        public FullHttpResponse setStatus(HttpResponseStatus status) {
            ((HttpResponse)this.message).setStatus(status);
            return this;
        }

        @Override
        public HttpResponseStatus getStatus() {
            return ((HttpResponse)this.message).getStatus();
        }

        @Override
        public FullHttpResponse setProtocolVersion(HttpVersion version) {
            super.setProtocolVersion(version);
            return this;
        }

        @Override
        public FullHttpResponse retain(int increment) {
            super.retain(increment);
            return this;
        }

        @Override
        public FullHttpResponse retain() {
            super.retain();
            return this;
        }
    }

    private static final class AggregatedFullHttpRequest
    extends AggregatedFullHttpMessage
    implements FullHttpRequest {
        private AggregatedFullHttpRequest(HttpRequest request, ByteBuf content, HttpHeaders trailingHeaders) {
            super(request, content, trailingHeaders);
        }

        @Override
        public FullHttpRequest copy() {
            DefaultFullHttpRequest copy = new DefaultFullHttpRequest(this.getProtocolVersion(), this.getMethod(), this.getUri(), this.content().copy());
            copy.headers().set(this.headers());
            copy.trailingHeaders().set(this.trailingHeaders());
            return copy;
        }

        @Override
        public FullHttpRequest duplicate() {
            DefaultFullHttpRequest duplicate = new DefaultFullHttpRequest(this.getProtocolVersion(), this.getMethod(), this.getUri(), this.content().duplicate());
            duplicate.headers().set(this.headers());
            duplicate.trailingHeaders().set(this.trailingHeaders());
            return duplicate;
        }

        @Override
        public FullHttpRequest retain(int increment) {
            super.retain(increment);
            return this;
        }

        @Override
        public FullHttpRequest retain() {
            super.retain();
            return this;
        }

        @Override
        public FullHttpRequest setMethod(HttpMethod method) {
            ((HttpRequest)this.message).setMethod(method);
            return this;
        }

        @Override
        public FullHttpRequest setUri(String uri) {
            ((HttpRequest)this.message).setUri(uri);
            return this;
        }

        @Override
        public HttpMethod getMethod() {
            return ((HttpRequest)this.message).getMethod();
        }

        @Override
        public String getUri() {
            return ((HttpRequest)this.message).getUri();
        }

        @Override
        public FullHttpRequest setProtocolVersion(HttpVersion version) {
            super.setProtocolVersion(version);
            return this;
        }
    }

    private static abstract class AggregatedFullHttpMessage
    extends DefaultByteBufHolder
    implements FullHttpMessage {
        protected final HttpMessage message;
        private HttpHeaders trailingHeaders;

        private AggregatedFullHttpMessage(HttpMessage message, ByteBuf content, HttpHeaders trailingHeaders) {
            super(content);
            this.message = message;
            this.trailingHeaders = trailingHeaders;
        }

        @Override
        public HttpHeaders trailingHeaders() {
            return this.trailingHeaders;
        }

        public void setTrailingHeaders(HttpHeaders trailingHeaders) {
            this.trailingHeaders = trailingHeaders;
        }

        @Override
        public HttpVersion getProtocolVersion() {
            return this.message.getProtocolVersion();
        }

        @Override
        public FullHttpMessage setProtocolVersion(HttpVersion version) {
            this.message.setProtocolVersion(version);
            return this;
        }

        @Override
        public HttpHeaders headers() {
            return this.message.headers();
        }

        @Override
        public DecoderResult getDecoderResult() {
            return this.message.getDecoderResult();
        }

        @Override
        public void setDecoderResult(DecoderResult result) {
            this.message.setDecoderResult(result);
        }

        @Override
        public FullHttpMessage retain(int increment) {
            super.retain(increment);
            return this;
        }

        @Override
        public FullHttpMessage retain() {
            super.retain();
            return this;
        }

        @Override
        public abstract FullHttpMessage copy();

        @Override
        public abstract FullHttpMessage duplicate();
    }
}

