/*
 * Decompiled with CFR 0.152.
 */
package org.cassandraunit.shaded.io.netty.handler.codec.sctp;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.cassandraunit.shaded.io.netty.buffer.ByteBuf;
import org.cassandraunit.shaded.io.netty.buffer.Unpooled;
import org.cassandraunit.shaded.io.netty.channel.ChannelHandlerContext;
import org.cassandraunit.shaded.io.netty.channel.sctp.SctpMessage;
import org.cassandraunit.shaded.io.netty.handler.codec.MessageToMessageDecoder;

public class SctpMessageCompletionHandler
extends MessageToMessageDecoder<SctpMessage> {
    private final Map<Integer, ByteBuf> fragments = new HashMap<Integer, ByteBuf>();

    @Override
    protected void decode(ChannelHandlerContext ctx, SctpMessage msg, List<Object> out) throws Exception {
        ByteBuf byteBuf = msg.content();
        int protocolIdentifier = msg.protocolIdentifier();
        int streamIdentifier = msg.streamIdentifier();
        boolean isComplete = msg.isComplete();
        ByteBuf frag = this.fragments.containsKey(streamIdentifier) ? this.fragments.remove(streamIdentifier) : Unpooled.EMPTY_BUFFER;
        if (isComplete && !frag.isReadable()) {
            out.add(msg);
        } else if (!isComplete && frag.isReadable()) {
            this.fragments.put(streamIdentifier, Unpooled.wrappedBuffer(frag, byteBuf));
        } else if (isComplete && frag.isReadable()) {
            this.fragments.remove(streamIdentifier);
            SctpMessage assembledMsg = new SctpMessage(protocolIdentifier, streamIdentifier, Unpooled.wrappedBuffer(frag, byteBuf));
            out.add(assembledMsg);
        } else {
            this.fragments.put(streamIdentifier, byteBuf);
        }
        byteBuf.retain();
    }
}

