/*
 * Decompiled with CFR 0.152.
 */
package org.cassandraunit.shaded.org.apache.cassandra.thrift;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import org.apache.thrift.transport.TServerTransport;
import org.apache.thrift.transport.TTransportException;
import org.cassandraunit.shaded.org.apache.cassandra.thrift.TCustomSocket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TCustomServerSocket
extends TServerTransport {
    private static final Logger logger = LoggerFactory.getLogger(TCustomServerSocket.class);
    private ServerSocket serverSocket = null;
    private final boolean keepAlive;
    private final Integer sendBufferSize;
    private final Integer recvBufferSize;

    public TCustomServerSocket(InetSocketAddress bindAddr, boolean keepAlive, Integer sendBufferSize, Integer recvBufferSize, Integer listenBacklog) throws TTransportException {
        try {
            this.serverSocket = new ServerSocket();
            this.serverSocket.setReuseAddress(true);
            this.serverSocket.bind(bindAddr, listenBacklog);
        }
        catch (IOException ioe) {
            this.serverSocket = null;
            throw new TTransportException("Could not create ServerSocket on address " + bindAddr.toString() + ".");
        }
        this.keepAlive = keepAlive;
        this.sendBufferSize = sendBufferSize;
        this.recvBufferSize = recvBufferSize;
    }

    public TCustomServerSocket(ServerSocket socket, boolean keepAlive, Integer sendBufferSize, Integer recvBufferSize) {
        this.serverSocket = socket;
        this.keepAlive = keepAlive;
        this.sendBufferSize = sendBufferSize;
        this.recvBufferSize = recvBufferSize;
    }

    protected TCustomSocket acceptImpl() throws TTransportException {
        if (this.serverSocket == null) {
            throw new TTransportException(1, "No underlying server socket.");
        }
        TCustomSocket tsocket = null;
        Socket socket = null;
        try {
            socket = this.serverSocket.accept();
            tsocket = new TCustomSocket(socket);
            tsocket.setTimeout(0);
        }
        catch (IOException iox) {
            throw new TTransportException((Throwable)iox);
        }
        try {
            socket.setKeepAlive(this.keepAlive);
        }
        catch (SocketException se) {
            logger.warn("Failed to set keep-alive on Thrift socket.", (Throwable)se);
        }
        if (this.sendBufferSize != null) {
            try {
                socket.setSendBufferSize(this.sendBufferSize);
            }
            catch (SocketException se) {
                logger.warn("Failed to set send buffer size on Thrift socket.", (Throwable)se);
            }
        }
        if (this.recvBufferSize != null) {
            try {
                socket.setReceiveBufferSize(this.recvBufferSize);
            }
            catch (SocketException se) {
                logger.warn("Failed to set receive buffer size on Thrift socket.", (Throwable)se);
            }
        }
        return tsocket;
    }

    public void listen() throws TTransportException {
        if (this.serverSocket != null) {
            try {
                this.serverSocket.setSoTimeout(100);
            }
            catch (SocketException sx) {
                logger.error("Could not set socket timeout.", (Throwable)sx);
            }
        }
    }

    public void close() {
        if (this.serverSocket != null) {
            try {
                this.serverSocket.close();
            }
            catch (IOException iox) {
                logger.warn("Could not close server socket.", (Throwable)iox);
            }
            this.serverSocket = null;
        }
    }

    public void interrupt() {
        this.close();
    }
}

