/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.config;

import java.beans.IntrospectionException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.cassandra.config.Config;
import org.apache.cassandra.config.ConfigurationLoader;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.config.ParameterizedClass;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.commons.lang3.SystemUtils;
import org.cassandraunit.shaded.com.google.common.collect.Lists;
import org.cassandraunit.shaded.com.google.common.collect.Maps;
import org.cassandraunit.shaded.com.google.common.collect.Sets;
import org.cassandraunit.shaded.com.google.common.io.ByteStreams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.TypeDescription;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Constructor;
import org.yaml.snakeyaml.error.YAMLException;
import org.yaml.snakeyaml.introspector.MissingProperty;
import org.yaml.snakeyaml.introspector.Property;
import org.yaml.snakeyaml.introspector.PropertyUtils;

public class YamlConfigurationLoader
implements ConfigurationLoader {
    private static final Logger logger = LoggerFactory.getLogger(YamlConfigurationLoader.class);
    private static final String DEFAULT_CONFIGURATION = "cassandra.yaml";
    private static final URL storageConfigURL = YamlConfigurationLoader.getStorageConfigURL();

    private static URL getStorageConfigURL() throws ConfigurationException {
        URL url;
        block4: {
            String configUrl = System.getProperty("cassandra.config");
            if (configUrl == null) {
                configUrl = DEFAULT_CONFIGURATION;
            }
            try {
                url = new URL(configUrl);
                url.openStream().close();
            }
            catch (Exception e) {
                ClassLoader loader = DatabaseDescriptor.class.getClassLoader();
                url = loader.getResource(configUrl);
                if (url != null) break block4;
                String required = "file:" + File.separator + File.separator;
                if (!configUrl.startsWith(required)) {
                    throw new ConfigurationException(String.format("Expecting URI in variable: [cassandra.config]. Found[%s]. Please prefix the file with [%s%s] for local files and [%s<server>%s] for remote files. If you are executing this from an external tool, it needs to set Config.setClientMode(true) to avoid loading configuration.", configUrl, required, File.separator, required, File.separator));
                }
                throw new ConfigurationException("Cannot locate " + configUrl + ".  If this is a local file, please confirm you've provided " + required + File.separator + " as a URI prefix.");
            }
        }
        logger.info("Configuration location: {}", (Object)url);
        return url;
    }

    @Override
    public Config loadConfig() throws ConfigurationException {
        return this.loadConfig(storageConfigURL);
    }

    public Config loadConfig(URL url) throws ConfigurationException {
        try {
            byte[] configBytes;
            logger.debug("Loading settings from {}", (Object)url);
            try (InputStream is = url.openStream();){
                configBytes = ByteStreams.toByteArray(is);
            }
            catch (IOException e) {
                throw new AssertionError((Object)e);
            }
            CustomConstructor constructor = new CustomConstructor(Config.class);
            PropertiesChecker propertiesChecker = new PropertiesChecker();
            constructor.setPropertyUtils(propertiesChecker);
            Yaml yaml = new Yaml((BaseConstructor)constructor);
            Config result = this.loadConfig(yaml, configBytes);
            propertiesChecker.check();
            return result;
        }
        catch (YAMLException e) {
            throw new ConfigurationException("Invalid yaml: " + url + SystemUtils.LINE_SEPARATOR + " Error: " + e.getMessage(), false);
        }
    }

    private Config loadConfig(Yaml yaml, byte[] configBytes) {
        Config config = (Config)yaml.loadAs((InputStream)new ByteArrayInputStream(configBytes), Config.class);
        return config == null ? new Config() : config;
    }

    private static class PropertiesChecker
    extends PropertyUtils {
        private final Set<String> missingProperties = new HashSet<String>();
        private final Set<String> nullProperties = new HashSet<String>();

        public PropertiesChecker() {
            this.setSkipMissingProperties(true);
        }

        public Property getProperty(Class<? extends Object> type, String name) throws IntrospectionException {
            final Property result = super.getProperty(type, name);
            if (result instanceof MissingProperty) {
                this.missingProperties.add(result.getName());
            }
            return new Property(result.getName(), result.getType()){

                public void set(Object object, Object value) throws Exception {
                    if (value == null && this.get(object) != null) {
                        nullProperties.add(this.getName());
                    }
                    result.set(object, value);
                }

                public Class<?>[] getActualTypeArguments() {
                    return result.getActualTypeArguments();
                }

                public Object get(Object object) {
                    return result.get(object);
                }
            };
        }

        public void check() throws ConfigurationException {
            if (!this.nullProperties.isEmpty()) {
                throw new ConfigurationException("Invalid yaml. Those properties " + this.nullProperties + " are not valid", false);
            }
            if (!this.missingProperties.isEmpty()) {
                throw new ConfigurationException("Invalid yaml. Please remove properties " + this.missingProperties + " from your cassandra.yaml", false);
            }
        }
    }

    static class CustomConstructor
    extends Constructor {
        CustomConstructor(Class<?> theRoot) {
            super(theRoot);
            TypeDescription seedDesc = new TypeDescription(ParameterizedClass.class);
            seedDesc.putMapPropertyType("parameters", String.class, String.class);
            this.addTypeDescription(seedDesc);
        }

        protected List<Object> createDefaultList(int initSize) {
            return Lists.newCopyOnWriteArrayList();
        }

        protected Map<Object, Object> createDefaultMap() {
            return Maps.newConcurrentMap();
        }

        protected Set<Object> createDefaultSet(int initSize) {
            return Sets.newConcurrentHashSet();
        }

        protected Set<Object> createDefaultSet() {
            return Sets.newConcurrentHashSet();
        }
    }
}

