/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3;

import java.util.Collection;
import java.util.Iterator;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.ReversedType;
import org.cassandraunit.shaded.com.google.common.base.MoreObjects;
import org.cassandraunit.shaded.com.google.common.base.Objects;

public class ColumnSpecification {
    public final String ksName;
    public final String cfName;
    public final ColumnIdentifier name;
    public final AbstractType<?> type;

    public ColumnSpecification(String ksName, String cfName, ColumnIdentifier name, AbstractType<?> type) {
        this.ksName = ksName;
        this.cfName = cfName;
        this.name = name;
        this.type = type;
    }

    public ColumnSpecification withAlias(ColumnIdentifier alias) {
        return new ColumnSpecification(this.ksName, this.cfName, alias, this.type);
    }

    public boolean isReversedType() {
        return this.type instanceof ReversedType;
    }

    public static boolean allInSameTable(Collection<ColumnSpecification> names) {
        if (names == null || names.isEmpty()) {
            return false;
        }
        Iterator<ColumnSpecification> iter = names.iterator();
        ColumnSpecification first = iter.next();
        while (iter.hasNext()) {
            ColumnSpecification name = iter.next();
            if (name.ksName.equals(first.ksName) && name.cfName.equals(first.cfName)) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object other) {
        if (!(other instanceof ColumnSpecification)) {
            return false;
        }
        ColumnSpecification that = (ColumnSpecification)other;
        return this.ksName.equals(that.ksName) && this.cfName.equals(that.cfName) && this.name.equals(that.name) && this.type.equals(that.type);
    }

    public int hashCode() {
        return Objects.hashCode(this.ksName, this.cfName, this.name, this.type);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("name", this.name).add("type", this.type).toString();
    }
}

