/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.functions;

import org.cassandraunit.shaded.com.google.common.base.Objects;

public final class FunctionName {
    public final String keyspace;
    public final String name;

    public static FunctionName nativeFunction(String name) {
        return new FunctionName("system", name);
    }

    public FunctionName(String keyspace, String name) {
        assert (name != null) : "Name parameter must not be null";
        this.keyspace = keyspace;
        this.name = name;
    }

    public FunctionName asNativeFunction() {
        return FunctionName.nativeFunction(this.name);
    }

    public boolean hasKeyspace() {
        return this.keyspace != null;
    }

    public final int hashCode() {
        return Objects.hashCode(this.keyspace, this.name);
    }

    public final boolean equals(Object o) {
        if (!(o instanceof FunctionName)) {
            return false;
        }
        FunctionName that = (FunctionName)o;
        return Objects.equal(this.keyspace, that.keyspace) && Objects.equal(this.name, that.name);
    }

    public final boolean equalsNativeFunction(FunctionName nativeFunction) {
        assert (nativeFunction.keyspace.equals("system"));
        if (this.hasKeyspace() && !this.keyspace.equals("system")) {
            return false;
        }
        return Objects.equal(this.name, nativeFunction.name);
    }

    public String toString() {
        return this.keyspace == null ? this.name : this.keyspace + "." + this.name;
    }
}

