/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.functions;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.cassandra.cql3.functions.AbstractFunction;
import org.apache.cassandra.cql3.functions.AggregateFunction;
import org.apache.cassandra.cql3.functions.Function;
import org.apache.cassandra.cql3.functions.FunctionName;
import org.apache.cassandra.cql3.functions.ScalarFunction;
import org.apache.cassandra.cql3.functions.UDFunction;
import org.apache.cassandra.cql3.functions.UDHelper;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.schema.Functions;
import org.apache.cassandra.tracing.Tracing;
import org.cassandraunit.shaded.com.google.common.base.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UDAggregate
extends AbstractFunction
implements AggregateFunction {
    protected static final Logger logger = LoggerFactory.getLogger(UDAggregate.class);
    protected final AbstractType<?> stateType;
    protected final ByteBuffer initcond;
    private final ScalarFunction stateFunction;
    private final ScalarFunction finalFunction;

    public UDAggregate(FunctionName name, List<AbstractType<?>> argTypes, AbstractType<?> returnType, ScalarFunction stateFunc, ScalarFunction finalFunc, ByteBuffer initcond) {
        super(name, argTypes, returnType);
        this.stateFunction = stateFunc;
        this.finalFunction = finalFunc;
        this.stateType = stateFunc != null ? stateFunc.returnType() : null;
        this.initcond = initcond;
    }

    public static UDAggregate create(Functions functions, FunctionName name, List<AbstractType<?>> argTypes, AbstractType<?> returnType, FunctionName stateFunc, FunctionName finalFunc, AbstractType<?> stateType, ByteBuffer initcond) throws InvalidRequestException {
        ArrayList stateTypes = new ArrayList(argTypes.size() + 1);
        stateTypes.add(stateType);
        stateTypes.addAll(argTypes);
        List<AbstractType<?>> finalTypes = Collections.singletonList(stateType);
        return new UDAggregate(name, argTypes, returnType, UDAggregate.resolveScalar(functions, name, stateFunc, stateTypes), finalFunc != null ? UDAggregate.resolveScalar(functions, name, finalFunc, finalTypes) : null, initcond);
    }

    public static UDAggregate createBroken(FunctionName name, List<AbstractType<?>> argTypes, AbstractType<?> returnType, ByteBuffer initcond, final InvalidRequestException reason) {
        return new UDAggregate(name, argTypes, returnType, null, null, initcond){

            @Override
            public AggregateFunction.Aggregate newAggregate() throws InvalidRequestException {
                throw new InvalidRequestException(String.format("Aggregate '%s' exists but hasn't been loaded successfully for the following reason: %s. Please see the server log for more details", this, reason.getMessage()));
            }
        };
    }

    @Override
    public boolean hasReferenceTo(Function function) {
        return this.stateFunction == function || this.finalFunction == function;
    }

    @Override
    public void addFunctionsTo(List<Function> functions) {
        functions.add(this);
        if (this.stateFunction != null) {
            this.stateFunction.addFunctionsTo(functions);
            if (this.finalFunction != null) {
                this.finalFunction.addFunctionsTo(functions);
            }
        }
    }

    @Override
    public boolean isAggregate() {
        return true;
    }

    @Override
    public boolean isNative() {
        return false;
    }

    public ScalarFunction stateFunction() {
        return this.stateFunction;
    }

    public ScalarFunction finalFunction() {
        return this.finalFunction;
    }

    public ByteBuffer initialCondition() {
        return this.initcond;
    }

    public AbstractType<?> stateType() {
        return this.stateType;
    }

    @Override
    public AggregateFunction.Aggregate newAggregate() throws InvalidRequestException {
        return new AggregateFunction.Aggregate(){
            private long stateFunctionCount;
            private long stateFunctionDuration;
            private ByteBuffer state;
            {
                this.reset();
            }

            @Override
            public void addInput(int protocolVersion, List<ByteBuffer> values) throws InvalidRequestException {
                long startTime = System.nanoTime();
                ++this.stateFunctionCount;
                ArrayList<ByteBuffer> fArgs = new ArrayList<ByteBuffer>(values.size() + 1);
                fArgs.add(this.state);
                fArgs.addAll(values);
                if (UDAggregate.this.stateFunction instanceof UDFunction) {
                    UDFunction udf = (UDFunction)UDAggregate.this.stateFunction;
                    if (udf.isCallableWrtNullable(fArgs)) {
                        this.state = udf.execute(protocolVersion, fArgs);
                    }
                } else {
                    this.state = UDAggregate.this.stateFunction.execute(protocolVersion, fArgs);
                }
                this.stateFunctionDuration += (System.nanoTime() - startTime) / 1000L;
            }

            @Override
            public ByteBuffer compute(int protocolVersion) throws InvalidRequestException {
                Tracing.trace("Executed UDA {}: {} call(s) to state function {} in {}\u03bcs", UDAggregate.this.name(), this.stateFunctionCount, UDAggregate.this.stateFunction.name(), this.stateFunctionDuration);
                if (UDAggregate.this.finalFunction == null) {
                    return this.state;
                }
                List<ByteBuffer> fArgs = Collections.singletonList(this.state);
                ByteBuffer result = UDAggregate.this.finalFunction.execute(protocolVersion, fArgs);
                return result;
            }

            @Override
            public void reset() {
                this.state = UDAggregate.this.initcond != null ? UDAggregate.this.initcond.duplicate() : null;
                this.stateFunctionDuration = 0L;
                this.stateFunctionCount = 0L;
            }
        };
    }

    private static ScalarFunction resolveScalar(Functions functions, FunctionName aName, FunctionName fName, List<AbstractType<?>> argTypes) throws InvalidRequestException {
        Optional<Function> fun = functions.find(fName, argTypes);
        if (!fun.isPresent()) {
            throw new InvalidRequestException(String.format("Referenced state function '%s %s' for aggregate '%s' does not exist", fName, Arrays.toString(UDHelper.driverTypes(argTypes)), aName));
        }
        if (!(fun.get() instanceof ScalarFunction)) {
            throw new InvalidRequestException(String.format("Referenced state function '%s %s' for aggregate '%s' is not a scalar function", fName, Arrays.toString(UDHelper.driverTypes(argTypes)), aName));
        }
        return (ScalarFunction)fun.get();
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof UDAggregate)) {
            return false;
        }
        UDAggregate that = (UDAggregate)o;
        return Objects.equal(this.name, that.name) && Functions.typesMatch(this.argTypes, that.argTypes) && Functions.typesMatch(this.returnType, that.returnType) && Objects.equal(this.stateFunction, that.stateFunction) && Objects.equal(this.finalFunction, that.finalFunction) && (this.stateType == that.stateType || this.stateType != null && this.stateType.equals(that.stateType, true)) && Objects.equal(this.initcond, that.initcond);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this.name, Functions.typeHashCode(this.argTypes), Functions.typeHashCode(this.returnType), this.stateFunction, this.finalFunction, this.stateType, this.initcond);
    }
}

