/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.statements;

import org.apache.cassandra.auth.Permission;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.config.ViewDefinition;
import org.apache.cassandra.cql3.CFName;
import org.apache.cassandra.cql3.statements.SchemaAlteringStatement;
import org.apache.cassandra.cql3.statements.TableAttributes;
import org.apache.cassandra.db.view.View;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.exceptions.RequestValidationException;
import org.apache.cassandra.exceptions.UnauthorizedException;
import org.apache.cassandra.schema.TableParams;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.service.MigrationManager;
import org.apache.cassandra.transport.Event;
import org.cassandraunit.shaded.org.apache.cassandra.thrift.ThriftValidation;

public class AlterViewStatement
extends SchemaAlteringStatement {
    private final TableAttributes attrs;

    public AlterViewStatement(CFName name, TableAttributes attrs) {
        super(name);
        this.attrs = attrs;
    }

    @Override
    public void checkAccess(ClientState state) throws UnauthorizedException, InvalidRequestException {
        CFMetaData baseTable = View.findBaseTable(this.keyspace(), this.columnFamily());
        if (baseTable != null) {
            state.hasColumnFamilyAccess(this.keyspace(), baseTable.cfName, Permission.ALTER);
        }
    }

    @Override
    public void validate(ClientState state) {
    }

    @Override
    public Event.SchemaChange announceMigration(boolean isLocalOnly) throws RequestValidationException {
        CFMetaData meta = ThriftValidation.validateColumnFamily(this.keyspace(), this.columnFamily());
        if (!meta.isView()) {
            throw new InvalidRequestException("Cannot use ALTER MATERIALIZED VIEW on Table");
        }
        ViewDefinition viewCopy = Schema.instance.getView(this.keyspace(), this.columnFamily()).copy();
        if (this.attrs == null) {
            throw new InvalidRequestException("ALTER MATERIALIZED VIEW WITH invoked, but no parameters found");
        }
        this.attrs.validate();
        TableParams params = this.attrs.asAlteredTableParams(viewCopy.metadata.params);
        if (params.gcGraceSeconds == 0) {
            throw new InvalidRequestException("Cannot alter gc_grace_seconds of a materialized view to 0, since this value is used to TTL undelivered updates. Setting gc_grace_seconds too low might cause undelivered updates to expire before being replayed.");
        }
        viewCopy.metadata.params(params);
        MigrationManager.announceViewUpdate(viewCopy, isLocalOnly);
        return new Event.SchemaChange(Event.SchemaChange.Change.UPDATED, Event.SchemaChange.Target.TABLE, this.keyspace(), this.columnFamily());
    }

    public String toString() {
        return String.format("AlterViewStatement(name=%s)", this.cfName);
    }
}

