/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.statements;

import java.util.regex.Pattern;
import org.apache.cassandra.auth.AuthenticatedUser;
import org.apache.cassandra.auth.DataResource;
import org.apache.cassandra.auth.FunctionResource;
import org.apache.cassandra.auth.Permission;
import org.apache.cassandra.auth.RoleResource;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.cql3.statements.KeyspaceAttributes;
import org.apache.cassandra.cql3.statements.SchemaAlteringStatement;
import org.apache.cassandra.exceptions.AlreadyExistsException;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.exceptions.RequestExecutionException;
import org.apache.cassandra.exceptions.RequestValidationException;
import org.apache.cassandra.exceptions.UnauthorizedException;
import org.apache.cassandra.locator.LocalStrategy;
import org.apache.cassandra.schema.KeyspaceMetadata;
import org.apache.cassandra.schema.KeyspaceParams;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.service.MigrationManager;
import org.apache.cassandra.service.QueryState;
import org.apache.cassandra.transport.Event;
import org.cassandraunit.shaded.org.apache.cassandra.thrift.ThriftValidation;

public class CreateKeyspaceStatement
extends SchemaAlteringStatement {
    private static final Pattern PATTERN_WORD_CHARS = Pattern.compile("\\w+");
    private final String name;
    private final KeyspaceAttributes attrs;
    private final boolean ifNotExists;

    public CreateKeyspaceStatement(String name, KeyspaceAttributes attrs, boolean ifNotExists) {
        this.name = name;
        this.attrs = attrs;
        this.ifNotExists = ifNotExists;
    }

    @Override
    public String keyspace() {
        return this.name;
    }

    @Override
    public void checkAccess(ClientState state) throws UnauthorizedException {
        state.hasAllKeyspacesAccess(Permission.CREATE);
    }

    @Override
    public void validate(ClientState state) throws RequestValidationException {
        ThriftValidation.validateKeyspaceNotSystem(this.name);
        if (!PATTERN_WORD_CHARS.matcher(this.name).matches()) {
            throw new InvalidRequestException(String.format("\"%s\" is not a valid keyspace name", this.name));
        }
        if (this.name.length() > 48) {
            throw new InvalidRequestException(String.format("Keyspace names shouldn't be more than %s characters long (got \"%s\")", 48, this.name));
        }
        this.attrs.validate();
        if (this.attrs.getReplicationStrategyClass() == null) {
            throw new ConfigurationException("Missing mandatory replication strategy class");
        }
        KeyspaceParams params = this.attrs.asNewKeyspaceParams();
        params.validate(this.name);
        if (params.replication.klass.equals(LocalStrategy.class)) {
            throw new ConfigurationException("Unable to use given strategy class: LocalStrategy is reserved for internal use.");
        }
    }

    @Override
    public Event.SchemaChange announceMigration(boolean isLocalOnly) throws RequestValidationException {
        KeyspaceMetadata ksm = KeyspaceMetadata.create(this.name, this.attrs.asNewKeyspaceParams());
        try {
            MigrationManager.announceNewKeyspace(ksm, isLocalOnly);
            return new Event.SchemaChange(Event.SchemaChange.Change.CREATED, this.keyspace());
        }
        catch (AlreadyExistsException e) {
            if (this.ifNotExists) {
                return null;
            }
            throw e;
        }
    }

    @Override
    protected void grantPermissionsToCreator(QueryState state) {
        try {
            RoleResource role = RoleResource.role(state.getClientState().getUser().getName());
            DataResource keyspace = DataResource.keyspace(this.keyspace());
            DatabaseDescriptor.getAuthorizer().grant(AuthenticatedUser.SYSTEM_USER, keyspace.applicablePermissions(), keyspace, role);
            FunctionResource functions = FunctionResource.keyspace(this.keyspace());
            DatabaseDescriptor.getAuthorizer().grant(AuthenticatedUser.SYSTEM_USER, functions.applicablePermissions(), functions, role);
        }
        catch (RequestExecutionException e) {
            throw new RuntimeException(e);
        }
    }
}

