/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.util.Comparator;
import java.util.Iterator;
import java.util.Objects;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.db.Columns;
import org.apache.cassandra.utils.btree.BTreeSet;
import org.cassandraunit.shaded.com.google.common.collect.Iterators;

public class PartitionColumns
implements Iterable<ColumnDefinition> {
    public static PartitionColumns NONE = new PartitionColumns(Columns.NONE, Columns.NONE);
    public final Columns statics;
    public final Columns regulars;

    public PartitionColumns(Columns statics, Columns regulars) {
        assert (statics != null && regulars != null);
        this.statics = statics;
        this.regulars = regulars;
    }

    public static PartitionColumns of(ColumnDefinition column) {
        return new PartitionColumns(column.isStatic() ? Columns.of(column) : Columns.NONE, column.isStatic() ? Columns.NONE : Columns.of(column));
    }

    public PartitionColumns without(ColumnDefinition column) {
        return new PartitionColumns(column.isStatic() ? this.statics.without(column) : this.statics, column.isStatic() ? this.regulars : this.regulars.without(column));
    }

    public PartitionColumns withoutStatics() {
        return this.statics.isEmpty() ? this : new PartitionColumns(Columns.NONE, this.regulars);
    }

    public PartitionColumns mergeTo(PartitionColumns that) {
        if (this == that) {
            return this;
        }
        Columns statics = this.statics.mergeTo(that.statics);
        Columns regulars = this.regulars.mergeTo(that.regulars);
        if (statics == this.statics && regulars == this.regulars) {
            return this;
        }
        if (statics == that.statics && regulars == that.regulars) {
            return that;
        }
        return new PartitionColumns(statics, regulars);
    }

    public boolean isEmpty() {
        return this.statics.isEmpty() && this.regulars.isEmpty();
    }

    public Columns columns(boolean isStatic) {
        return isStatic ? this.statics : this.regulars;
    }

    public boolean contains(ColumnDefinition column) {
        return column.isStatic() ? this.statics.contains(column) : this.regulars.contains(column);
    }

    public boolean includes(PartitionColumns columns) {
        return this.statics.containsAll(columns.statics) && this.regulars.containsAll(columns.regulars);
    }

    @Override
    public Iterator<ColumnDefinition> iterator() {
        return Iterators.concat(this.statics.iterator(), this.regulars.iterator());
    }

    public Iterator<ColumnDefinition> selectOrderIterator() {
        return Iterators.concat(this.statics.selectOrderIterator(), this.regulars.selectOrderIterator());
    }

    public int size() {
        return this.regulars.size() + this.statics.size();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[").append(this.statics).append(" | ").append(this.regulars).append("]");
        return sb.toString();
    }

    public boolean equals(Object other) {
        if (!(other instanceof PartitionColumns)) {
            return false;
        }
        PartitionColumns that = (PartitionColumns)other;
        return this.statics.equals(that.statics) && this.regulars.equals(that.regulars);
    }

    public int hashCode() {
        return Objects.hash(this.statics, this.regulars);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private BTreeSet.Builder<ColumnDefinition> regularColumns;
        private BTreeSet.Builder<ColumnDefinition> staticColumns;

        public Builder add(ColumnDefinition c) {
            if (c.isStatic()) {
                if (this.staticColumns == null) {
                    this.staticColumns = BTreeSet.builder(Comparator.naturalOrder());
                }
                this.staticColumns.add(c);
            } else {
                assert (c.isRegular());
                if (this.regularColumns == null) {
                    this.regularColumns = BTreeSet.builder(Comparator.naturalOrder());
                }
                this.regularColumns.add(c);
            }
            return this;
        }

        public Builder addAll(Iterable<ColumnDefinition> columns) {
            for (ColumnDefinition c : columns) {
                this.add(c);
            }
            return this;
        }

        public Builder addAll(PartitionColumns columns) {
            if (this.regularColumns == null && !columns.regulars.isEmpty()) {
                this.regularColumns = BTreeSet.builder(Comparator.naturalOrder());
            }
            for (ColumnDefinition c : columns.regulars) {
                this.regularColumns.add(c);
            }
            if (this.staticColumns == null && !columns.statics.isEmpty()) {
                this.staticColumns = BTreeSet.builder(Comparator.naturalOrder());
            }
            for (ColumnDefinition c : columns.statics) {
                this.staticColumns.add(c);
            }
            return this;
        }

        public PartitionColumns build() {
            return new PartitionColumns(this.staticColumns == null ? Columns.NONE : Columns.from(this.staticColumns.build()), this.regularColumns == null ? Columns.NONE : Columns.from(this.regularColumns.build()));
        }
    }
}

