/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.transform;

import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.DeletionTime;
import org.apache.cassandra.db.partitions.PartitionIterator;
import org.apache.cassandra.db.partitions.UnfilteredPartitionIterator;
import org.apache.cassandra.db.rows.BaseRowIterator;
import org.apache.cassandra.db.rows.RangeTombstoneMarker;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.db.rows.RowIterator;
import org.apache.cassandra.db.rows.UnfilteredRowIterator;
import org.apache.cassandra.db.transform.BaseIterator;
import org.apache.cassandra.db.transform.BasePartitions;
import org.apache.cassandra.db.transform.BaseRows;
import org.apache.cassandra.db.transform.FilteredPartitions;
import org.apache.cassandra.db.transform.FilteredRows;
import org.apache.cassandra.db.transform.MoreContents;
import org.apache.cassandra.db.transform.UnfilteredPartitions;
import org.apache.cassandra.db.transform.UnfilteredRows;

public abstract class Transformation<I extends BaseRowIterator<?>> {
    void attachTo(BasePartitions partitions) {
    }

    void attachTo(BaseRows rows) {
    }

    protected void onClose() {
    }

    protected void onPartitionClose() {
    }

    protected I applyToPartition(I partition) {
        return partition;
    }

    protected Row applyToRow(Row row) {
        return row;
    }

    protected RangeTombstoneMarker applyToMarker(RangeTombstoneMarker marker) {
        return marker;
    }

    protected DecoratedKey applyToPartitionKey(DecoratedKey key) {
        return key;
    }

    protected Row applyToStatic(Row row) {
        return row;
    }

    protected DeletionTime applyToDeletion(DeletionTime deletionTime) {
        return deletionTime;
    }

    public static UnfilteredPartitionIterator apply(UnfilteredPartitionIterator iterator, Transformation<? super UnfilteredRowIterator> transformation) {
        return Transformation.add(Transformation.mutable(iterator), transformation);
    }

    public static PartitionIterator apply(PartitionIterator iterator, Transformation<? super RowIterator> transformation) {
        return Transformation.add(Transformation.mutable(iterator), transformation);
    }

    public static UnfilteredRowIterator apply(UnfilteredRowIterator iterator, Transformation<?> transformation) {
        return Transformation.add(Transformation.mutable(iterator), transformation);
    }

    public static RowIterator apply(RowIterator iterator, Transformation<?> transformation) {
        return Transformation.add(Transformation.mutable(iterator), transformation);
    }

    static UnfilteredPartitions mutable(UnfilteredPartitionIterator iterator) {
        return iterator instanceof UnfilteredPartitions ? (UnfilteredPartitions)iterator : new UnfilteredPartitions(iterator);
    }

    static FilteredPartitions mutable(PartitionIterator iterator) {
        return iterator instanceof FilteredPartitions ? (FilteredPartitions)iterator : new FilteredPartitions(iterator);
    }

    static UnfilteredRows mutable(UnfilteredRowIterator iterator) {
        return iterator instanceof UnfilteredRows ? (UnfilteredRows)iterator : new UnfilteredRows(iterator);
    }

    static FilteredRows mutable(RowIterator iterator) {
        return iterator instanceof FilteredRows ? (FilteredRows)iterator : new FilteredRows(iterator);
    }

    static <E extends BaseIterator> E add(E to, Transformation add2) {
        to.add(add2);
        return to;
    }

    static <E extends BaseIterator> E add(E to, MoreContents add2) {
        to.add(add2);
        return to;
    }
}

