/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.transform;

import org.apache.cassandra.db.DeletionTime;
import org.apache.cassandra.db.rows.EncodingStats;
import org.apache.cassandra.db.rows.Unfiltered;
import org.apache.cassandra.db.rows.UnfilteredRowIterator;
import org.apache.cassandra.db.transform.BaseRows;
import org.apache.cassandra.db.transform.Transformation;

final class UnfilteredRows
extends BaseRows<Unfiltered, UnfilteredRowIterator>
implements UnfilteredRowIterator {
    private DeletionTime partitionLevelDeletion;

    public UnfilteredRows(UnfilteredRowIterator input) {
        super(input);
        this.partitionLevelDeletion = input.partitionLevelDeletion();
    }

    @Override
    void add(Transformation add2) {
        super.add(add2);
        this.partitionLevelDeletion = add2.applyToDeletion(this.partitionLevelDeletion);
    }

    @Override
    public DeletionTime partitionLevelDeletion() {
        return this.partitionLevelDeletion;
    }

    @Override
    public EncodingStats stats() {
        return ((UnfilteredRowIterator)this.input).stats();
    }

    @Override
    public boolean isEmpty() {
        return this.staticRow().isEmpty() && this.partitionLevelDeletion().isLive() && !this.hasNext();
    }
}

