/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.view;

import java.util.Collection;
import java.util.Collections;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nullable;
import org.apache.cassandra.concurrent.ScheduledExecutors;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.DeletionTime;
import org.apache.cassandra.db.Mutation;
import org.apache.cassandra.db.ReadExecutionController;
import org.apache.cassandra.db.ReadQuery;
import org.apache.cassandra.db.SinglePartitionReadCommand;
import org.apache.cassandra.db.SystemKeyspace;
import org.apache.cassandra.db.compaction.CompactionInfo;
import org.apache.cassandra.db.compaction.CompactionManager;
import org.apache.cassandra.db.compaction.OperationType;
import org.apache.cassandra.db.lifecycle.SSTableSet;
import org.apache.cassandra.db.partitions.UnfilteredPartitionIterators;
import org.apache.cassandra.db.rows.Rows;
import org.apache.cassandra.db.rows.UnfilteredRowIterator;
import org.apache.cassandra.db.rows.UnfilteredRowIterators;
import org.apache.cassandra.db.view.View;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.io.sstable.ReducingKeyIterator;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.repair.SystemDistributedKeyspace;
import org.apache.cassandra.service.StorageProxy;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.Pair;
import org.apache.cassandra.utils.UUIDGen;
import org.apache.cassandra.utils.concurrent.Refs;
import org.cassandraunit.shaded.com.google.common.base.Function;
import org.cassandraunit.shaded.com.google.common.collect.Iterables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ViewBuilder
extends CompactionInfo.Holder {
    private final ColumnFamilyStore baseCfs;
    private final View view;
    private final UUID compactionId;
    private volatile Token prevToken = null;
    private static final Logger logger = LoggerFactory.getLogger(ViewBuilder.class);
    private volatile boolean isStopped = false;

    public ViewBuilder(ColumnFamilyStore baseCfs, View view) {
        this.baseCfs = baseCfs;
        this.view = view;
        this.compactionId = UUIDGen.getTimeUUID();
    }

    private void buildKey(DecoratedKey key) {
        Collection<Mutation> mutations;
        ReadQuery selectQuery = this.view.getReadQuery();
        if (!selectQuery.selectsKey(key)) {
            return;
        }
        int nowInSec = FBUtilities.nowInSeconds();
        SinglePartitionReadCommand command = this.view.getSelectStatement().internalReadForView(key, nowInSec);
        UnfilteredRowIterator empty = UnfilteredRowIterators.noRowsIterator(this.baseCfs.metadata, key, Rows.EMPTY_STATIC_ROW, DeletionTime.LIVE, false);
        try (ReadExecutionController orderGroup = command.executionController();
             UnfilteredRowIterator data = UnfilteredPartitionIterators.getOnlyElement(command.executeLocally(orderGroup), command);){
            mutations = this.baseCfs.keyspace.viewManager.forTable(this.baseCfs.metadata).generateViewUpdates(Collections.singleton(this.view), data, empty, nowInSec);
        }
        if (!mutations.isEmpty()) {
            AtomicLong noBase = new AtomicLong(Long.MAX_VALUE);
            StorageProxy.mutateMV(key.getKey(), mutations, true, noBase);
        }
    }

    public void run() {
        Token lastToken;
        Function<org.apache.cassandra.db.lifecycle.View, Iterable<SSTableReader>> function;
        logger.trace("Running view builder for {}.{}", (Object)this.baseCfs.metadata.ksName, (Object)this.view.name);
        UUID localHostId = SystemKeyspace.getLocalHostId();
        String ksname = this.baseCfs.metadata.ksName;
        String viewName = this.view.name;
        if (SystemKeyspace.isViewBuilt(ksname, viewName)) {
            if (!SystemKeyspace.isViewStatusReplicated(ksname, viewName)) {
                this.updateDistributed(ksname, viewName, localHostId);
            }
            return;
        }
        Collection<Range<Token>> ranges = StorageService.instance.getLocalRanges(this.baseCfs.metadata.ksName);
        final Pair<Integer, Token> buildStatus = SystemKeyspace.getViewBuildStatus(ksname, viewName);
        if (buildStatus == null) {
            this.baseCfs.forceBlockingFlush();
            function = org.apache.cassandra.db.lifecycle.View.selectFunction(SSTableSet.CANONICAL);
            int generation = Integer.MIN_VALUE;
            try (Refs<SSTableReader> temp = this.baseCfs.selectAndReference((Function<org.apache.cassandra.db.lifecycle.View, Iterable<SSTableReader>>)function).refs;){
                for (SSTableReader reader : temp) {
                    generation = Math.max(reader.descriptor.generation, generation);
                }
            }
            SystemKeyspace.beginViewBuild(ksname, viewName, generation);
            lastToken = null;
        } else {
            function = new Function<org.apache.cassandra.db.lifecycle.View, Iterable<SSTableReader>>(){

                @Override
                @Nullable
                public Iterable<SSTableReader> apply(org.apache.cassandra.db.lifecycle.View view) {
                    Iterable<SSTableReader> readers = org.apache.cassandra.db.lifecycle.View.selectFunction(SSTableSet.CANONICAL).apply(view);
                    if (readers != null) {
                        return Iterables.filter(readers, ssTableReader -> ssTableReader.descriptor.generation <= (Integer)buildStatus2.left);
                    }
                    return null;
                }
            };
            lastToken = (Token)buildStatus.right;
        }
        this.prevToken = lastToken;
        try (Refs<SSTableReader> sstables = this.baseCfs.selectAndReference((Function<org.apache.cassandra.db.lifecycle.View, Iterable<SSTableReader>>)function).refs;){
            ReducingKeyIterator iter = new ReducingKeyIterator(sstables);
            Object object = null;
            try {
                SystemDistributedKeyspace.startViewBuild(ksname, viewName, localHostId);
                while (!this.isStopped && iter.hasNext()) {
                    DecoratedKey key = iter.next();
                    Token token = key.getToken();
                    if (lastToken != null && lastToken.compareTo(token) >= 0) continue;
                    for (Range range : ranges) {
                        if (!range.contains(token)) continue;
                        this.buildKey(key);
                        if (this.prevToken != null && this.prevToken.compareTo(token) == 0) continue;
                        SystemKeyspace.updateViewBuildStatus(ksname, viewName, key.getToken());
                        this.prevToken = token;
                    }
                    lastToken = null;
                }
                if (!this.isStopped) {
                    SystemKeyspace.finishViewBuildStatus(ksname, viewName);
                    this.updateDistributed(ksname, viewName, localHostId);
                }
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (iter != null) {
                    if (object != null) {
                        try {
                            iter.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        iter.close();
                    }
                }
            }
        }
        catch (Exception e) {
            ScheduledExecutors.nonPeriodicTasks.schedule(() -> CompactionManager.instance.submitViewBuilder(this), 5L, TimeUnit.MINUTES);
            logger.warn("Materialized View failed to complete, sleeping 5 minutes before restarting", (Throwable)e);
        }
    }

    private void updateDistributed(String ksname, String viewName, UUID localHostId) {
        try {
            SystemDistributedKeyspace.successfulViewBuild(ksname, viewName, localHostId);
            SystemKeyspace.setViewBuiltReplicated(ksname, viewName);
        }
        catch (Exception e) {
            ScheduledExecutors.nonPeriodicTasks.schedule(() -> CompactionManager.instance.submitViewBuilder(this), 5L, TimeUnit.MINUTES);
            logger.warn("Failed to updated the distributed status of view, sleeping 5 minutes before retrying", (Throwable)e);
        }
    }

    @Override
    public CompactionInfo getCompactionInfo() {
        long rangesLeft = 0L;
        long rangesTotal = 0L;
        Token lastToken = this.prevToken;
        for (Range<Token> range : StorageService.instance.getLocalRanges(this.baseCfs.keyspace.getName())) {
            ++rangesLeft;
            ++rangesTotal;
            if (lastToken != null && !range.contains(lastToken)) continue;
            rangesLeft = 0L;
        }
        return new CompactionInfo(this.baseCfs.metadata, OperationType.VIEW_BUILD, rangesLeft, rangesTotal, "ranges", this.compactionId);
    }

    @Override
    public void stop() {
        this.isStopped = true;
    }
}

